/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class Parasaurolophus
extends Prehistoric {
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(Parasaurolophus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ParaAnimationLogic animationLogic = new ParaAnimationLogic(this);
    private static final String STAND = "animation.parasaurolophus.stand";
    private static final String STAND_UP = "animation.parasaurolophus.stand_up";

    public Parasaurolophus(EntityType<Parasaurolophus> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FleeBattleGoal(this, 1.0));
        this.f_21345_.m_25352_(19, (Goal)new ParaStandGoal());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STANDING, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (!this.f_19853_.f_46443_ && (SLEEPING.equals(key) || SITTING.equals(key))) {
            this.setStanding(false);
        }
        super.m_7350_(key);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Standing", this.isStanding());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setStanding(compound.m_128471_("Standing"));
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.PARASAUROLOPHUS;
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42398_;
    }

    @Override
    public double m_6048_() {
        return super.m_6048_() + 0.4;
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public void setStanding(boolean standing) {
        this.f_19804_.m_135381_(STANDING, (Object)standing);
    }

    @Override
    public float getGenderedScale() {
        return this.getGender() == Gender.MALE ? 1.15f : super.getGenderedScale();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PARASAUROLOPHUS_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.PARASAUROLOPHUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PARASAUROLOPHUS_DEATH.get();
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<Parasaurolophus> controller = new PausableAnimationController<Parasaurolophus>(this, "Movement/Idle", 5.0f, this.animationLogic::paraPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<Parasaurolophus>(this, "Attack", 0.0f, this.getAnimationLogic()::attackPredicate));
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    static class ParaAnimationLogic
    extends AnimationLogic<Prehistoric> {
        public ParaAnimationLogic(Parasaurolophus entity) {
            super(entity);
        }

        public PlayState paraPredicate(AnimationEvent<Parasaurolophus> event) {
            if (this.isBlocked()) {
                return PlayState.STOP;
            }
            AnimationController controller = event.getController();
            if (this.tryNextAnimation(controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            if (((Parasaurolophus)event.getAnimatable()).isStanding()) {
                controller.setAnimation(new AnimationBuilder().playOnce(Parasaurolophus.STAND_UP).loop(Parasaurolophus.STAND));
                return PlayState.CONTINUE;
            }
            double animationSpeed = 1.0;
            if (((Prehistoric)this.entity).m_5803_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (((Parasaurolophus)event.getAnimatable()).sitSystem.isSitting()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (((Prehistoric)this.entity).m_20069_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
            } else if (event.isMoving()) {
                animationSpeed = this.addMovementAnimation(event, true);
            } else {
                this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
            ParaAnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                controller.transitionLengthTicks = newAnimation.get().transitionLength();
                controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName(), (ILoopType)(newAnimation.get().loop() ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
            }
            return PlayState.CONTINUE;
        }
    }

    class ParaStandGoal
    extends Goal {
        private int cooldown;

        public ParaStandGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cooldown > Parasaurolophus.this.f_19797_ || Parasaurolophus.this.m_20069_() || Parasaurolophus.this.m_6107_()) {
                return false;
            }
            return Parasaurolophus.this.f_19796_.nextInt(100) == 0;
        }

        public boolean m_8045_() {
            return !Parasaurolophus.this.m_20160_() && !Parasaurolophus.this.m_20069_() && !Parasaurolophus.this.m_6107_() && Parasaurolophus.this.f_19796_.nextInt(ParaStandGoal.m_186073_((int)2000)) != 0;
        }

        public void m_8056_() {
            this.cooldown = 0;
            Parasaurolophus.this.setStanding(true);
        }

        public void m_8041_() {
            this.cooldown = Parasaurolophus.this.f_19797_ + (Parasaurolophus.this.f_19796_.nextInt(120) + 10) * 20;
            Parasaurolophus.this.setStanding(false);
        }
    }
}

