/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.ai.AmphibiousWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoRandomSwimGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatBlockGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EnterWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.GrabMeleeAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PassiveFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.WaterPlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomSwimMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.PrehistoricLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.AmphibiousPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.damagesource.ModDamageSources;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.manager.AnimationData;

public abstract class PrehistoricSwimming
extends Prehistoric
implements SwimmingAnimal {
    public static final int MAX_TIME_IN_WATER = 1000;
    public static final int MAX_TIME_ON_LAND = 1000;
    private static final EntityDataAccessor<Boolean> GRABBING = SynchedEntityData.m_135353_(PrehistoricSwimming.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeInWater = 0;
    private int timeOnLand = 0;
    protected boolean isLandNavigator;
    private boolean beached;

    protected PrehistoricSwimming(EntityType<? extends Prehistoric> entityType, Level level, ResourceLocation animationLocation) {
        super(entityType, level, animationLocation);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.switchNavigator(false);
    }

    protected PrehistoricSwimming(EntityType<? extends Prehistoric> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.switchNavigator(false);
    }

    @Override
    protected void m_8099_() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.f_21345_.m_25352_(1, (Goal)new DinoPanicGoal(this, this.attributes().sprintMod()));
        if (this.aiAttackType() == PrehistoricEntityInfoAI.Attacking.GRAB) {
            this.f_21345_.m_25352_(5, (Goal)new GrabMeleeAttackGoal(this, this.attributes().sprintMod(), false));
        } else if (this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.NONE) {
            this.f_21345_.m_25352_(5, new DelayedAttackGoal<PrehistoricSwimming>(this, this.attributes().sprintMod(), false));
        }
        this.f_21345_.m_25352_(12, (Goal)this.matingGoal);
        if (this.data().diet() != Diet.PASSIVE) {
            this.f_21345_.m_25352_(15, (Goal)new EatFromFeederGoal(this));
            this.f_21345_.m_25352_(16, (Goal)new EatItemEntityGoal(this));
            this.f_21345_.m_25352_(17, (Goal)new EatBlockGoal(this));
        } else {
            this.f_21345_.m_25352_(15, (Goal)new PassiveFoodGoal(this));
        }
        this.f_21345_.m_25352_(18, new WaterPlayGoal<PrehistoricSwimming>(this, 1.0));
        this.f_21345_.m_25352_(20, (Goal)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 7.0f, 2.0f, false));
        this.f_21345_.m_25352_(21, new EnterWaterGoal<PrehistoricSwimming>(this, 1.0f));
        this.f_21345_.m_25352_(22, new DinoRandomSwimGoal<PrehistoricSwimming>(this, 1.0));
        this.f_21345_.m_25352_(23, (Goal)new AmphibiousWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(25, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(26, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new HuntingTargetGoal(this));
    }

    public static boolean isOverWater(LivingEntity entity) {
        if (entity.f_19853_.m_6425_(entity.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        if (entity.f_19853_.m_6425_(entity.m_142538_().m_6625_(2)).m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        return entity.f_19853_.m_6425_(entity.m_142538_().m_6625_(3)).m_205070_(FluidTags.f_13131_);
    }

    @Override
    protected void m_8022_() {
        boolean bl = !this.isBeached() && !this.m_5803_();
        this.f_21345_.m_25360_(Goal.Flag.MOVE, bl && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.JUMP, bl && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, bl);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GRABBING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TimeInWater", this.timeInWater);
        compound.m_128405_("TimeOnLand", this.timeOnLand);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.timeInWater = compound.m_128451_("TimeInWater");
        this.timeOnLand = compound.m_128451_("TimeOnLand");
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation<PrehistoricSwimming>(this, level);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new SmoothTurningMoveControl(this);
            this.f_21365_ = new PrehistoricLookControl(this);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new CustomSwimMoveControl<PrehistoricSwimming>(this);
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
            this.isLandNavigator = false;
        }
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public boolean isAmphibious() {
        return this.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC;
    }

    @Override
    public boolean canSwim() {
        return this.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC;
    }

    @Override
    public double swimSpeed() {
        return this.swimSpeed;
    }

    public boolean m_6040_() {
        return true;
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        boolean wasBeached = this.beached;
        boolean inWater = this.m_20069_();
        boolean bl = this.beached = !this.isAmphibious() && !inWater && this.m_20096_();
        if (!this.f_19853_.f_46443_) {
            if (this.isAmphibious()) {
                if (this.isLandNavigator && inWater) {
                    this.switchNavigator(false);
                } else if (!this.isLandNavigator && !inWater && this.m_20096_()) {
                    this.switchNavigator(true);
                }
            } else if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (inWater) {
                ++this.timeInWater;
                this.timeOnLand = 0;
                this.m_20242_(true);
                if (this.m_5803_() && this.f_19853_.m_8055_(this.m_142538_().m_142022_(0.0, (double)(this.m_20206_() + 1.0f), 0.0)).m_60795_()) {
                    this.m_20242_(false);
                }
            } else if (this.f_19861_) {
                this.timeInWater = 0;
                ++this.timeOnLand;
            } else {
                this.m_20242_(false);
            }
            if (this.isDoingGrabAttack() && !this.m_20160_()) {
                this.setDoingGrabAttack(false);
            }
        } else {
            if (wasBeached != this.beached) {
                this.refreshTexturePath();
            }
            if (this.beached) {
                this.m_146926_(0.0f);
            }
        }
    }

    protected void m_203347_(TagKey<Fluid> fluidTag) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
    }

    public void m_21043_(LivingEntity livingEntity, boolean isFlying) {
        super.m_21043_(livingEntity, this.m_20069_());
    }

    protected float m_5632_(float yRot, float animStep) {
        if (this.isBeached()) {
            return animStep;
        }
        return super.m_5632_(yRot, animStep);
    }

    protected void handleAirSupply(int airSupply) {
        if (!this.canBreatheOnLand() && this.m_6084_() && !this.m_20072_() && !this.m_21525_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -40) {
                this.m_20301_(0);
                this.m_6469_(ModDamageSources.SUFFOCATE, 2.0f);
            }
        } else {
            this.m_20301_(500);
        }
    }

    @Override
    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (passenger != this.getRidingPlayer() && this.isDoingGrabAttack()) {
            this.getEntityHitboxData().getAnchorData().getAnchorPos("grab_pos").ifPresentOrElse(pos -> passenger.m_6034_(pos.f_82479_, pos.f_82480_ + passenger.m_6049_(), pos.f_82481_), () -> {
                float t = 5.0f * Mth.m_14031_((float)((float)Math.PI + (float)this.f_19797_ * 0.275f));
                float radius = 0.24499999f * this.m_6134_() * -3.0f;
                float angle = (float)Math.PI / 180 * this.f_20883_ + 3.15f + t * 1.75f * 0.05f;
                double extraX = radius * Mth.m_14031_((float)((float)Math.PI + angle));
                double extraY = 0.065 * (double)this.m_6134_();
                double extraZ = radius * Mth.m_14089_((float)angle);
                passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ);
            });
        }
    }

    public float grabTargetSize() {
        return this.m_20205_() / 2.0f;
    }

    @Override
    public void startGrabAttack(Entity target) {
        target.m_20329_((Entity)this);
        this.setDoingGrabAttack(true);
    }

    @Override
    public void stopGrabAttack(Entity target) {
        target.m_8127_();
        this.setDoingGrabAttack(false);
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    @Override
    public void disableCustomAI(byte type, boolean disableAI) {
        if (type == 0 || type == 2) {
            super.disableCustomAI(type, disableAI);
            this.m_20242_(disableAI);
        } else {
            super.disableCustomAI(type, disableAI);
        }
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.m_6107_() && !this.m_20160_() || !this.isAmphibious() && !this.m_20069_()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        LivingEntity rider = (LivingEntity)this.m_6688_();
        if (rider == null || !this.m_5807_() || this.m_6109_() && !this.steering.trySteering(rider)) {
            if (this.m_6142_() && this.m_20069_()) {
                this.m_19920_(this.m_6113_(), travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.9));
                if (!this.m_20068_() && this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                }
                this.m_21043_((LivingEntity)this, this instanceof FlyingAnimal);
            } else {
                super.m_7023_(travelVector);
            }
            return;
        }
        if (!this.m_20069_()) {
            super.m_7023_(travelVector);
            return;
        }
        this.m_146922_(rider.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(rider.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        float newStrafeMovement = rider.f_20900_ * 0.5f;
        float newForwardMovement = rider.f_20902_;
        if (this.m_6109_()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            this.steering.waterTravel(new Vec3((double)newStrafeMovement, travelVector.f_82480_, (double)newForwardMovement), (Player)rider);
        } else {
            this.m_20256_(Vec3.f_82478_);
            this.m_21043_((LivingEntity)this, this instanceof FlyingAnimal);
        }
    }

    public void m_20321_(boolean downwards) {
        if (this.m_20205_() < 2.0f) {
            super.m_20321_(downwards);
        }
    }

    @Override
    public boolean m_6147_() {
        return false;
    }

    public void destroyBoat(Entity targetSailor) {
        Entity entity = targetSailor.m_20202_();
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            if (!this.f_19853_.f_46443_) {
                boat.m_6074_();
                if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.m_19998_((ItemLike)boat.m_38387_().m_38434_());
                    }
                    for (i = 0; i < 2; ++i) {
                        this.m_19998_((ItemLike)Items.f_42398_);
                    }
                }
            }
        }
    }

    @Override
    public boolean m_5807_() {
        return !this.isAmphibious() ? this.m_20069_() && super.m_5807_() : super.m_5807_();
    }

    public boolean isBeached() {
        return this.beached;
    }

    @Override
    public int timeInWater() {
        return this.timeInWater;
    }

    @Override
    public int timeOnLand() {
        return this.timeOnLand;
    }

    @Override
    public boolean isDoingGrabAttack() {
        return (Boolean)this.f_19804_.m_135370_(GRABBING);
    }

    public void setDoingGrabAttack(boolean grabbing) {
        this.f_19804_.m_135381_(GRABBING, (Object)grabbing);
    }

    @NotNull
    public AnimationInfo nextGrabbingAnimation() {
        return this.nextIdleAnimation();
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<PrehistoricSwimming> controller = new PausableAnimationController<PrehistoricSwimming>(this, "Movement/Idle", 5.0f, this.getAnimationLogic()::waterPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<PrehistoricSwimming>(this, "Attack", 0.0f, this.getAnimationLogic()::grabAttackPredicate));
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }
}

