/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlyingSleepSystem
extends SleepSystem {
    private final PrehistoricFlying mob;
    private BlockPos landingPos;
    private long nextTryTick = -1L;

    public FlyingSleepSystem(PrehistoricFlying mob) {
        super(mob);
        this.mob = mob;
    }

    @Override
    protected void trySleeping() {
        if (this.nextTryTick == -1L) {
            if (!this.mob.m_142592_() && !this.mob.isTakingOff()) {
                super.trySleeping();
                return;
            }
            if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.BOTH) {
                if (this.mob.m_21187_().nextInt(1200) == 0 && this.wantsToSleep() && this.canSleep()) {
                    this.trySleepingOrLanding();
                }
            } else if (this.mob.aiActivityType() != PrehistoricEntityInfoAI.Activity.NO_SLEEP && this.mob.m_21187_().nextInt(200) == 0 && this.wantsToSleep() && this.canSleep()) {
                this.trySleepingOrLanding();
            }
        } else if (this.nextTryTick == this.mob.f_19853_.m_46467_()) {
            this.trySleepingOrLanding();
        }
    }

    private void trySleepingOrLanding() {
        if (this.mob.m_142592_() || this.mob.isTakingOff()) {
            this.landingPos = this.findGroundTarget();
            if (this.landingPos != null) {
                this.mob.moveTo(Vec3.m_82512_((Vec3i)this.landingPos), true, true);
                this.nextTryTick = this.mob.f_19853_.m_46467_() + 100L;
            } else {
                this.nextTryTick = this.mob.f_19853_.m_46467_() + 20L;
            }
        } else {
            this.setSleeping(true);
            this.nextTryTick = -1L;
        }
    }

    @Override
    protected boolean canSleep() {
        if (PrehistoricSwimming.isOverWater((LivingEntity)this.mob)) {
            return false;
        }
        if (this.isDisabled() || this.mob.hasTarget() || this.mob.m_142581_() != null || this.mob.getCurrentOrder() == OrderType.FOLLOW || this.mob.m_20160_()) {
            return false;
        }
        if (this.mob.isDeadlyHungry()) {
            return false;
        }
        return !this.mob.m_20069_();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.landingPos != null) {
            if (this.mob.m_142592_()) {
                this.mob.moveTo(Vec3.m_82512_((Vec3i)this.landingPos), true, true);
            } else {
                this.landingPos = null;
            }
        }
    }

    @Override
    public void setSleeping(boolean sleeping) {
        super.setSleeping(sleeping);
        if (sleeping) {
            this.landingPos = null;
        }
    }

    private BlockPos findGroundTarget() {
        if (!this.mob.f_19853_.m_46859_(this.mob.m_142538_().m_7495_())) {
            return this.mob.m_142538_().m_7495_();
        }
        if (!this.mob.f_19853_.m_46859_(this.mob.m_142538_().m_6625_(2))) {
            return this.mob.m_142538_().m_6625_(2);
        }
        BlockPos sleepPos = this.findTreePosition(16);
        if (sleepPos == null) {
            sleepPos = this.mob.findLandPosition(false);
        }
        return sleepPos;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private BlockPos findTreePosition(int radius) {
        dx = 0;
        dz = -1;
        mutable = new BlockPos.MutableBlockPos();
        mutable2 = new BlockPos.MutableBlockPos();
        i = 0;
        x = 0;
        z = 0;
        while ((double)i < Math.pow(radius * 2, 2.0)) {
            if (-radius < x && x <= radius && -radius < z && z <= radius) {
                bX = x + this.mob.m_142538_().m_123341_();
                bZ = z + this.mob.m_142538_().m_123343_();
                height = this.mob.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, bX, bZ);
                leaves = this.mob.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, bX, bZ);
                if (!((double)height > this.mob.m_20186_())) {
                    mutable.m_122178_(bX, height - 1, bZ);
                    if (this.mob.f_19853_.m_8055_((BlockPos)mutable).m_204336_(BlockTags.f_13035_)) {
                        if (height > leaves + 3) {
                            return mutable.m_7949_();
                        }
                        if (this.mob.f_19853_.m_8055_((BlockPos)mutable2.m_122178_(bX, leaves, bZ)).m_204336_(BlockTags.f_13106_)) {
                            for (Direction dir : Direction.Plane.HORIZONTAL) {
                                if (this.mob.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, bX + dir.m_122429_(), bZ + dir.m_122431_()) >= height) continue;
                                return mutable.m_7949_();
                            }
                        } else {
                            ** GOTO lbl-1000
                        }
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 6 sources

            {
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    t = dx;
                    dx = -dz;
                    dz = t;
                }
                x += dx;
                z += dz;
            }
            ++i;
        }
        return null;
    }
}

