/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import net.minecraft.nbt.CompoundTag;

public class SitSystem
extends AISystem {
    private int ticksSat;
    private int sitCooldown = 3600;

    public SitSystem(Prehistoric mob) {
        super(mob);
    }

    @Override
    public void serverTick() {
        if (this.sitCooldown > 0) {
            --this.sitCooldown;
        }
        if (!this.isSitting() && this.canSit() && (this.sitCooldown == 0 && this.mob.m_21187_().nextInt(1000) == 0 || this.mob.getCurrentOrder() == OrderType.STAY)) {
            this.setSitting(true);
        }
        if (this.isSitting()) {
            ++this.ticksSat;
            if (this.mob.getCurrentOrder() != OrderType.STAY && (this.ticksSat > 300 && this.mob.m_21187_().nextInt(100) == 0 || !this.canSit())) {
                this.setSitting(false);
            }
        }
    }

    protected boolean canSit() {
        if (this.isDisabled() || this.mob.hasTarget() || this.mob.m_20160_() || this.mob.m_142581_() != null || this.mob.getCurrentOrder() == OrderType.FOLLOW) {
            return false;
        }
        if (this.mob.isDeadlyHungry()) {
            return false;
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC) {
            return this.mob.m_20069_();
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
            return this.mob.m_20069_() || this.mob.m_20096_();
        }
        return this.mob.m_20096_();
    }

    public boolean isSitting() {
        return (Boolean)this.mob.m_20088_().m_135370_(Prehistoric.SITTING);
    }

    public void setSitting(boolean sitting) {
        this.mob.m_20088_().m_135381_(Prehistoric.SITTING, (Object)sitting);
        if (sitting) {
            this.ticksSat = 0;
            this.mob.m_21573_().m_26573_();
            this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        tag.m_128379_("Sitting", this.isSitting());
    }

    @Override
    public void load(CompoundTag tag) {
        this.setSitting(tag.m_128471_("Sitting"));
    }
}

