/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class DateCondition
extends VariantCondition {
    private static final int MONTH_ONLY = 0;
    private static final int DAY_ONLY = 1;
    private static final int MONTH_AND_DAY = 2;
    private static final String MONTH_KEY = "month";
    private static final String DAY_KEY = "day";
    private final int mode;
    private final LocalDate date;

    private DateCondition(double chance, int mode, LocalDate date) {
        super(chance);
        this.mode = mode;
        this.date = date;
    }

    public boolean test(Random random, ZonedDateTime now) {
        if (random.nextDouble() > this.chance) {
            return false;
        }
        return switch (this.mode) {
            case 0 -> {
                if (now.getMonth() == this.date.getMonth()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (now.getDayOfMonth() == this.date.getDayOfMonth()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (now.getMonth() == this.date.getMonth() && now.getDayOfMonth() == this.date.getDayOfMonth()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("Unexpected value: " + this.mode);
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateCondition that = (DateCondition)object;
        return this.chance == that.chance && this.mode == that.mode && Objects.equals(this.date, that.date);
    }

    public int hashCode() {
        return Objects.hash(this.chance, this.mode, this.date);
    }

    public static class Serializer
    implements VariantCondition.Serializer<DateCondition> {
        public DateCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            double chance = GsonHelper.m_144742_((JsonObject)root, (String)"chance", (double)1.0);
            if (root.has(DateCondition.DAY_KEY)) {
                int day = root.get(DateCondition.DAY_KEY).getAsInt();
                if (root.has(DateCondition.MONTH_KEY)) {
                    LocalDate date = LocalDate.of(2025, root.get(DateCondition.MONTH_KEY).getAsInt(), day);
                    return new DateCondition(chance, 2, date);
                }
                LocalDate date = LocalDate.of(2025, Month.JANUARY, day);
                return new DateCondition(chance, 1, date);
            }
            if (root.has(DateCondition.MONTH_KEY)) {
                LocalDate date = LocalDate.of(2025, root.get(DateCondition.MONTH_KEY).getAsInt(), 1);
                return new DateCondition(chance, 0, date);
            }
            throw new JsonSyntaxException("Missing month or day entry");
        }

        @Override
        public void save(CompoundTag tag, DateCondition condition) {
            tag.m_128347_("Chance", condition.chance);
            tag.m_128405_("Mode", condition.mode);
            tag.m_128405_("Month", condition.date.getMonthValue());
            tag.m_128405_("Day", condition.date.getDayOfMonth());
        }

        @Override
        public DateCondition load(CompoundTag tag) {
            LocalDate date = LocalDate.of(LocalDate.now().getYear(), tag.m_128451_("Month"), tag.m_128451_("Day"));
            return new DateCondition(tag.m_128459_("Chance"), tag.m_128451_("Mode"), date);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, DateCondition condition) {
            buf.writeDouble(condition.chance);
            buf.writeInt(condition.mode);
            buf.writeInt(condition.date.getMonthValue());
            buf.writeInt(condition.date.getDayOfMonth());
        }

        @Override
        public DateCondition fromNetwork(FriendlyByteBuf buf) {
            return new DateCondition(buf.readDouble(), buf.readInt(), LocalDate.of(LocalDate.now().getYear(), buf.readInt(), buf.readInt()));
        }
    }
}

