/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.energy;

import com.github.teamfossilsarcheology.fossil.block.entity.CommonEnergyStorage;
import net.minecraft.nbt.Tag;
import net.minecraftforge.energy.EnergyStorage;

public abstract class FAEnergyStorage
extends EnergyStorage
implements CommonEnergyStorage {
    protected FAEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        if (received != 0) {
            this.onChange();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (extracted != 0) {
            this.onChange();
        }
        return extracted;
    }

    protected abstract void onChange();

    public void deserializeNBT(Tag nbt) {
        if (nbt == null) {
            this.energy = 0;
        } else {
            super.deserializeNBT(nbt);
        }
    }

    @Override
    public int getEnergy() {
        return this.getEnergyStored();
    }

    @Override
    public void extractEnergy(int maxExtract) {
        this.extractEnergy(maxExtract, false);
    }

    @Override
    public void load(Tag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    public Tag save() {
        return this.serializeNBT();
    }
}

