/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.mixin;

import com.github.teamfossilsarcheology.fossil.block.entity.CommonEnergyStorage;
import com.github.teamfossilsarcheology.fossil.block.entity.EnergyContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.MachineContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EnergyContainerBlockEntity.class})
public abstract class EnergyContainerBlockEntityMixin
extends MachineContainerBlockEntity {
    @Shadow
    private CommonEnergyStorage energyStorage;
    @Unique
    private LazyOptional<IEnergyStorage> fossilsArcheologyRevival$lazyEnergyStorage = LazyOptional.empty();

    private EnergyContainerBlockEntityMixin(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void onLoad() {
        super.onLoad();
        this.fossilsArcheologyRevival$lazyEnergyStorage = LazyOptional.of(() -> (IEnergyStorage)this.energyStorage);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && side != null && cap == CapabilityEnergy.ENERGY && FossilConfig.isEnabled("machinesRequireEnergy")) {
            return this.fossilsArcheologyRevival$lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fossilsArcheologyRevival$lazyEnergyStorage.invalidate();
    }
}

