/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class C2SHitPlayerMessage {
    private final int entityId;
    private final int targetId;

    public C2SHitPlayerMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.targetId = buf.readInt();
    }

    public C2SHitPlayerMessage(Entity entity, Entity target) {
        this.entityId = entity.m_142049_();
        this.targetId = target.m_142049_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.targetId);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.CLIENT) {
            return;
        }
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Entity entity = player.f_19853_.m_6815_(this.entityId);
            if (entity instanceof Prehistoric) {
                Prehistoric prehistoric = (Prehistoric)entity;
                if (player.m_142049_() == this.targetId) {
                    prehistoric.attackTarget((LivingEntity)player);
                }
            }
        });
    }
}

