/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class C2SRiderForceFlyingMessage {
    private static final Component FLYING_DISABLED = new TranslatableComponent("entity.fossil.flying.disabled");
    private final int entityId;
    private final boolean flying;

    public C2SRiderForceFlyingMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.flying = buf.readBoolean();
    }

    public C2SRiderForceFlyingMessage(int entityId, boolean flying) {
        this.entityId = entityId;
        this.flying = flying;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.flying);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.CLIENT) {
            return;
        }
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Entity entity = player.f_19853_.m_6815_(this.entityId);
            if (player.m_20194_() != null && !player.m_20194_().m_129915_()) {
                player.m_5661_(FLYING_DISABLED, false);
            } else if (entity instanceof PrehistoricFlying) {
                PrehistoricFlying mob = (PrehistoricFlying)entity;
                Entity rider = entity.m_6688_();
                if (rider != null && rider.m_142049_() == player.m_142049_()) {
                    if (this.flying) {
                        if (mob.hasTakeOffAnimation()) {
                            mob.startTakeOff();
                        } else {
                            mob.setFlying(true);
                        }
                    } else {
                        mob.setFlying(true);
                        mob.setFlying(false);
                    }
                }
            }
        });
    }
}

