/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.villager;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.enchantment.ModEnchantments;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ModTrades {
    public static List<VillagerTrades.ItemListing> getArcheoList(int level) {
        ArrayList<VillagerTrades.ItemListing> list = new ArrayList<VillagerTrades.ItemListing>();
        switch (level) {
            case 1: {
                list.add(new ItemsForEmeralds((Item)ModItems.RELIC_SCRAP.get(), 3, 1, 8, 2));
                list.add(new EmeraldForItems((ItemLike)ModItems.POTTERY_SHARD.get(), 3, 8, 6));
                list.add(new ItemsForEmeralds((Block)ModBlocks.WORKTABLE.get(), 1, 1, 4, 1));
                break;
            }
            case 2: {
                list.add(new ItemsForEmeralds((Item)ModItems.STONE_TABLET.get(), 4, 1, 6, 4));
                list.add(new ItemsForEmeralds(Items.f_42517_, 1, 1, 4));
                list.add(new ItemsForEmeralds((Item)ModItems.WOODEN_JAVELIN.get(), 1, 1, 1));
                break;
            }
            case 3: {
                list.add(new ItemsForEmeralds((Item)ModItems.STONE_JAVELIN.get(), 2, 1, 2));
                list.add(new ItemsForEmeralds((Item)ModItems.BROKEN_SWORD.get(), 6, 1, 2, 12));
                list.add(new ItemsForEmeralds((Item)ModItems.BROKEN_HELMET.get(), 6, 1, 2, 12));
                list.add(new ItemsForEmeralds((Block)ModBlocks.AMPHORA_VASE_DAMAGED.get(), 3, 1, 3, 4));
                list.add(new ItemsForEmeralds((Block)ModBlocks.VOLUTE_VASE_DAMAGED.get(), 3, 1, 3, 4));
                break;
            }
            case 4: {
                list.add(new ItemsForEmeralds((Block)ModBlocks.KYLIX_VASE_DAMAGED.get(), 3, 1, 3, 6));
                list.add(new ItemsForEmeralds((Block)ModBlocks.ANCIENT_GLASS.get(), 4, 4, 6, 12));
                list.add(new ItemsForEmeralds((Block)ModBlocks.ANCIENT_WOOD_PLANKS.get(), 2, 4, 6, 6));
                list.add(new EmeraldForItems((ItemLike)ModBlocks.SKELETON_FIGURINE_DESTROYED.get(), 2, 1, 2, 8));
                list.add(new EmeraldForItems((ItemLike)ModBlocks.ZOMBIE_FIGURINE_DESTROYED.get(), 2, 1, 2, 8));
                list.add(new EmeraldForItems((ItemLike)ModBlocks.ENDERMAN_FIGURINE_DESTROYED.get(), 2, 1, 2, 8));
                list.add(new EmeraldForItems((ItemLike)ModBlocks.STEVE_FIGURINE_DESTROYED.get(), 2, 1, 2, 8));
                list.add(new EmeraldForItems((ItemLike)ModBlocks.PIGLIN_FIGURINE_DESTROYED.get(), 2, 1, 2, 8));
                break;
            }
            case 5: {
                list.add(new EnchantBookForEmeralds((Enchantment)ModEnchantments.ARCHEOLOGY.get(), 10));
                list.add(new ItemsAndEmeraldsToItems((ItemLike)ModItems.BROKEN_HELMET.get(), 1, (Item)ModItems.ANCIENT_HELMET.get(), 1, 2, 10));
                list.add(new ItemsAndEmeraldsToItems((ItemLike)ModItems.BROKEN_SWORD.get(), 1, (Item)ModItems.ANCIENT_SWORD.get(), 1, 2, 10));
                list.add(new ItemsForEmeralds((Block)ModBlocks.ANCIENT_STONE.get(), 4, 4, 6, 12));
            }
        }
        return list;
    }

    public static List<VillagerTrades.ItemListing> getPaleoList(int level) {
        ArrayList<VillagerTrades.ItemListing> list = new ArrayList<VillagerTrades.ItemListing>();
        switch (level) {
            case 1: {
                list.add(new ItemsForEmeralds((Item)ModItems.BIO_FOSSIL.get(), 1, 1, 1));
                list.add(new EmeraldForItems((ItemLike)ModBlocks.SKULL_BLOCK.get(), 2, 12, 4));
                list.add(new EmeraldForItems((ItemLike)Items.f_42500_, 10, 12, 2));
                break;
            }
            case 2: {
                list.add(new ItemsForEmeralds((Item)ModItems.TAR_DROP.get(), 2, 1, 2));
                list.add(new ItemsForEmeralds((Item)ModItems.PlANT_FOSSIL.get(), 2, 1, 2));
                list.add(new EmeraldForItems((ItemLike)ModItems.BIO_GOO.get(), 3, 6, 6));
                break;
            }
            case 3: {
                list.add(new ItemsForEmeralds((Item)ModItems.FROZEN_MEAT.get(), 3, 1, 2));
                list.add(new ItemsForEmeralds((Item)ModItems.TAR_FOSSIL.get(), 3, 1, 3));
                break;
            }
            case 4: {
                list.add(new ItemsForEmeralds((Item)ModItems.CHICKEN_ESSENCE.get(), 3, 1, 6));
                list.add(new ItemsForEmeralds((Item)ModItems.FAILURESAURUS_FLESH.get(), 5, 2, 12));
                list.add(new ItemsForEmeralds((Block)ModBlocks.PERMAFROST_BLOCK.get(), 2, 4, 6, 4));
                list.add(new ItemsForEmeralds((Item)ModItems.SHALE_FOSSIL.get(), 3, 1, 6));
                list.add(new EmeraldForItems((ItemLike)ModItems.ELASMOTHERIUM_FUR.get(), 6, 6, 6));
                list.add(new EmeraldForItems((ItemLike)ModItems.MAMMOTH_FUR.get(), 6, 6, 6));
                list.add(new EmeraldForItems((ItemLike)ModItems.MAGIC_CONCH.get(), 2, 2, 8));
                break;
            }
            case 5: {
                list.add(new EnchantBookForEmeralds((Enchantment)ModEnchantments.PALEONTOLOGY.get(), 10));
                list.add(new ItemsForEmeralds((Item)ModItems.BONE_HELMET.get(), 3, 1, 2));
                list.add(new ItemsForEmeralds((Item)ModItems.BONE_CHESTPLATE.get(), 4, 1, 3));
                list.add(new ItemsForEmeralds((Item)ModItems.BONE_LEGGINGS.get(), 3, 1, 2));
                list.add(new ItemsForEmeralds((Item)ModItems.BONE_BOOTS.get(), 2, 1, 1));
            }
        }
        return list;
    }

    static class ItemsForEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeralds(Block block, int emeraldCost, int numberOfItems, int maxUses, int villagerXp) {
            this(new ItemStack((ItemLike)block), emeraldCost, numberOfItems, maxUses, villagerXp);
        }

        public ItemsForEmeralds(Item item, int emeraldCost, int numberOfItems, int villagerXp) {
            this(new ItemStack((ItemLike)item), emeraldCost, numberOfItems, 12, villagerXp);
        }

        public ItemsForEmeralds(Item item, int emeraldCost, int numberOfItems, int maxUses, int villagerXp) {
            this(new ItemStack((ItemLike)item), emeraldCost, numberOfItems, maxUses, villagerXp);
        }

        public ItemsForEmeralds(ItemStack itemStack, int emeraldCost, int numberOfItems, int maxUses, int villagerXp) {
            this(itemStack, emeraldCost, numberOfItems, maxUses, villagerXp, 0.05f);
        }

        public ItemsForEmeralds(ItemStack itemStack, int emeraldCost, int numberOfItems, int maxUses, int villagerXp, float priceMultiplier) {
            this.itemStack = itemStack;
            this.emeraldCost = emeraldCost;
            this.numberOfItems = numberOfItems;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_5670_(Entity trader, Random random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)this.itemStack.m_41720_(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class EmeraldForItems
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int cost;
        private final int emeraldCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EmeraldForItems(ItemLike itemLike, int cost, int maxUses, int villagerXp) {
            this(itemLike, 1, cost, maxUses, villagerXp);
        }

        public EmeraldForItems(ItemLike itemLike, int emeraldCount, int cost, int maxUses, int villagerXp) {
            this.item = itemLike.m_5456_();
            this.emeraldCount = emeraldCount;
            this.cost = cost;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_5670_(Entity trader, Random random) {
            ItemStack itemStack = new ItemStack((ItemLike)this.item, this.cost);
            return new MerchantOffer(itemStack, new ItemStack((ItemLike)Items.f_42616_, this.emeraldCount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class EnchantBookForEmeralds
    implements VillagerTrades.ItemListing {
        private final Enchantment enchantment;
        private final int villagerXp;

        public EnchantBookForEmeralds(Enchantment enchantment, int villagerXp) {
            this.enchantment = enchantment;
            this.villagerXp = villagerXp;
        }

        public MerchantOffer m_5670_(Entity trader, Random random) {
            int level = Mth.m_14072_((Random)random, (int)this.enchantment.m_44702_(), (int)this.enchantment.m_6586_());
            ItemStack itemStack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(this.enchantment, level));
            int cost = 2 + random.nextInt(5 + level * 10) + 3 * level;
            if (this.enchantment.m_6591_()) {
                cost *= 2;
            }
            if (cost > 64) {
                cost = 64;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, cost), new ItemStack((ItemLike)Items.f_42517_), itemStack, 12, this.villagerXp, 0.2f);
        }
    }

    static class ItemsAndEmeraldsToItems
    implements VillagerTrades.ItemListing {
        private final ItemStack fromItem;
        private final int fromCount;
        private final int emeraldCost;
        private final ItemStack toItem;
        private final int toCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsAndEmeraldsToItems(ItemLike fromItem, int fromCount, Item toItem, int toCount, int maxUses, int villagerXp) {
            this(fromItem, fromCount, 12, toItem, toCount, maxUses, villagerXp);
        }

        public ItemsAndEmeraldsToItems(ItemLike fromItem, int fromCount, int emeraldCost, Item toItem, int toCount, int maxUses, int villagerXp) {
            this.fromItem = new ItemStack(fromItem);
            this.fromCount = fromCount;
            this.emeraldCost = emeraldCost;
            this.toItem = new ItemStack((ItemLike)toItem);
            this.toCount = toCount;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)this.fromItem.m_41720_(), this.fromCount), new ItemStack((ItemLike)this.toItem.m_41720_(), this.toCount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

