/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.placement;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import org.jetbrains.annotations.NotNull;

public record LazyRandomSpreadPlacement(String spacingEntry, String separationEntry, RandomSpreadType spreadType, int salt, Vec3i locateOffset) implements StructurePlacement
{
    public static final Codec<LazyRandomSpreadPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("spacingEntry").forGetter(LazyRandomSpreadPlacement::spacingEntry), (App)Codec.STRING.fieldOf("separationEntry").forGetter(LazyRandomSpreadPlacement::separationEntry), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(LazyRandomSpreadPlacement::spreadType), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(LazyRandomSpreadPlacement::salt), (App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(LazyRandomSpreadPlacement::locateOffset)).apply((Applicative)instance, LazyRandomSpreadPlacement::new));
    public static final StructurePlacementType<LazyRandomSpreadPlacement> TYPE = () -> CODEC;

    public LazyRandomSpreadPlacement(String spacingEntry, String separationEntry, RandomSpreadType spreadType, int salt) {
        this(spacingEntry, separationEntry, spreadType, salt, Vec3i.f_123288_);
    }

    public ChunkPos getPotentialFeatureChunk(long seed, int x, int z) {
        int spacing = FossilConfig.getInt(this.spacingEntry);
        int separation = FossilConfig.getInt(this.separationEntry);
        int m = Math.floorDiv(x, spacing);
        int n = Math.floorDiv(z, spacing);
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190058_(seed, m, n, this.salt());
        int o = spacing - separation;
        int p = this.spreadType().m_205024_((RandomSource)worldgenRandom, o);
        int q = this.spreadType().m_205024_((RandomSource)worldgenRandom, o);
        return new ChunkPos(m * spacing + p, n * spacing + q);
    }

    public boolean m_212129_(ChunkGenerator generator, long seed, int x, int z) {
        ChunkPos chunkPos = this.getPotentialFeatureChunk(seed, x, z);
        return chunkPos.f_45578_ == x && chunkPos.f_45579_ == z;
    }

    @NotNull
    public StructurePlacementType<?> m_203443_() {
        return TYPE;
    }
}

