/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.CastleFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ConfigurableStructureFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.HellBoatFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.TreasureRoomFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.forge.ModStructuresImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;

public class ModStructures {
    public static final Tuple<JigsawConfiguration, CastleFeature> ANU_CASTLE = ModStructures.createStructure("anu_castle", new CastleFeature());
    public static final Tuple<JigsawConfiguration, ConfigurableStructureFeature> CONFIGURABLE_STRUCTURE = ModStructures.createStructure("configurable_structure", new ConfigurableStructureFeature());
    public static final Tuple<RangeConfiguration, HellBoatFeature> HELL_BOAT = ModStructures.createStructure("hell_boat", new HellBoatFeature());
    public static final Tuple<NoneFeatureConfiguration, TreasureRoomFeature> TREASURE_ROOM = ModStructures.createStructure("treasure_room", new TreasureRoomFeature());

    private static <C extends FeatureConfiguration, F extends StructureFeature<C>> Tuple<C, F> createStructure(String name, F feature) {
        return new Tuple(FossilMod.location(name), feature);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void register() {
        ModStructuresImpl.register();
    }

    public record Tuple<C extends FeatureConfiguration, F extends StructureFeature<C>>(ResourceLocation location, F feature) {
    }
}

