/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CalamitesTreeFeature
extends CustomTreeFeature {
    @Override
    protected boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        int treeHeight = context.m_159776_().nextInt(15) + 15;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        BlockState log = ((RotatedPillarBlock)ModBlocks.CALAMITES_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.CALAMITES_LEAVES.get()).m_49966_();
        BlockPos canopyCenter = pos.m_7494_();
        int minWidth = 2;
        int maxWidth = 4;
        float widthStep = (float)(maxWidth - minWidth) / (float)treeHeight;
        while (canopyCenter.m_123342_() < pos.m_6630_(treeHeight - 1).m_123342_()) {
            int difference = pos.m_6630_(treeHeight).m_123342_() - canopyCenter.m_123342_();
            float canopyWidth = (float)minWidth + widthStep * (float)difference;
            if (difference > 4) {
                canopyCenter = canopyCenter.m_6630_(4);
                this.genCircle(level, canopyCenter, canopyWidth - 2.0f, false);
                this.genCircle(level, canopyCenter.m_7494_(), canopyWidth - 1.0f, false);
                level.m_7731_(canopyCenter.m_142127_(), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
                level.m_7731_(canopyCenter.m_142125_(), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
                level.m_7731_(canopyCenter.m_142126_(), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
                level.m_7731_(canopyCenter.m_142128_(), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
                this.genCircle(level, canopyCenter.m_6630_(2), canopyWidth, true);
                this.genCircle(level, canopyCenter.m_6630_(3), canopyWidth + 1.0f, true);
                continue;
            }
            BlockPos.MutableBlockPos topBlocks = canopyCenter.m_6630_(difference).m_122032_();
            level.m_7731_((BlockPos)topBlocks, log, 19);
            level.m_7731_((BlockPos)topBlocks.m_122175_(Direction.UP, 1), log, 19);
            level.m_7731_((BlockPos)topBlocks.m_122175_(Direction.UP, 1), log, 19);
            this.placeLeaf(level, topBlocks.m_142127_(), leaves);
            this.placeLeaf(level, topBlocks.m_142125_(), leaves);
            this.placeLeaf(level, topBlocks.m_142126_(), leaves);
            this.placeLeaf(level, topBlocks.m_142128_(), leaves);
            this.placeLeaf(level, (BlockPos)topBlocks.m_122175_(Direction.UP, 1), leaves);
            canopyCenter = canopyCenter.m_6630_(4);
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
        }
        return true;
    }

    private void genCircle(WorldGenLevel level, BlockPos pos, float size, boolean spikes) {
        BlockState leaves = ((LeavesBlock)ModBlocks.CALAMITES_LEAVES.get()).m_49966_();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142022_((double)(-size), 0.0, (double)(-size)), (BlockPos)pos.m_142022_((double)size, 0.0, (double)size))) {
            int distanceX = Math.abs(blockpos.m_123341_() - pos.m_123341_());
            int distanceZ = Math.abs(blockpos.m_123343_() - pos.m_123343_());
            if (spikes) {
                boolean corner = blockpos.m_123341_() == pos.m_123341_() || blockpos.m_123343_() == pos.m_123343_() || distanceX == distanceZ;
                if (!corner || !(blockpos.m_123331_((Vec3i)pos) > (double)(size - 1.0f) * (double)(size - 1.0f)) || !(blockpos.m_123331_((Vec3i)pos) <= (double)(size * size))) continue;
                this.placeLeaf(level, blockpos, leaves);
                continue;
            }
            if (!(blockpos.m_123331_((Vec3i)pos) <= (double)(size * size))) continue;
            this.placeLeaf(level, blockpos, leaves);
        }
    }
}

