/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SigillariaTreeFeature
extends CustomTreeFeature {
    @Override
    protected boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        int treeHeight = random.nextInt(7) + 15;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        BlockState log = ((RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get()).m_49966_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            level.m_7731_(pos.m_5484_(direction, 2), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 19);
        }
        boolean twins = random.nextInt(4) != 0;
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
            double d = i;
            int n = twins ? -2 : 4;
            if (!(d < (double)(treeHeight - n) * 0.65)) continue;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                level.m_7731_(pos.m_6630_(i).m_142300_(direction), log, 19);
            }
        }
        BlockPos top = pos.m_6630_(treeHeight);
        if (twins) {
            Direction direction = Direction.m_122407_((int)random.nextInt(4));
            float bushWidth = random.nextInt(2) + 2;
            int secondHeight = 3 + random.nextInt(2) + (int)bushWidth;
            for (int i = 0; i <= secondHeight; ++i) {
                BlockPos offsetLeft = top.m_5484_(direction, i).m_6630_(i);
                BlockPos offsetRight = top.m_5484_(direction.m_122424_(), i).m_6630_(i);
                level.m_7731_(offsetLeft, log, 19);
                level.m_7731_(offsetRight, log, 19);
                if (i != secondHeight) continue;
                int bushHeight = random.nextInt(2) + 6;
                this.genCone(level, offsetLeft.m_6630_(bushHeight / 2).m_5484_(direction, -1), bushWidth, bushHeight, random);
                this.genCone(level, offsetRight.m_6630_(bushHeight / 2).m_5484_(direction.m_122424_(), -1), bushWidth, bushHeight, random);
            }
        } else {
            this.genCone(level, top.m_6625_(2), random.nextInt(2) + 2, random.nextInt(2) + 6, random);
        }
        return true;
    }

    private void genCone(WorldGenLevel level, BlockPos pos, float size, float height, Random random) {
        BlockState log = ((RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.SIGILLARIA_LEAVES.get()).m_49966_();
        float f = (size + height + size) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142022_((double)(-size), (double)(-height), (double)(-size)), (BlockPos)pos.m_142022_((double)size, (double)height, (double)size))) {
            int distanceX = Math.abs(blockpos.m_123341_() - pos.m_123341_());
            int distanceZ = Math.abs(blockpos.m_123343_() - pos.m_123343_());
            int distanceY = Math.abs(blockpos.m_123342_() - pos.m_123342_());
            if (!(blockpos.m_123331_((Vec3i)pos) <= (double)(f * f)) || !((float)(distanceX * distanceX + distanceZ * distanceZ) < f * f * (0.5f + random.nextFloat() * 0.5f) * ((float)(1 - distanceY % 2) + 0.25f))) continue;
            this.placeLeaf(level, blockpos, leaves);
        }
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_6625_((int)height), (BlockPos)pos.m_6630_((int)height - 4))) {
            if (!(blockpos.m_123331_((Vec3i)pos) <= (double)(f * f))) continue;
            level.m_7731_(blockpos, log, 19);
        }
    }
}

