/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class OptionalTextureLoader
extends ResourceLoader<Pair<Set<String>, Set<String>>> {
    public static final OptionalTextureLoader INSTANCE = new OptionalTextureLoader();
    private final Set<String> babyTextures = new HashSet<String>();
    private final Set<String> teenTextures = new HashSet<String>();

    public OptionalTextureLoader() {
        super(PackType.CLIENT_RESOURCES, "textures/entity", ".png");
    }

    @NotNull
    protected Pair<Set<String>, Set<String>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableSet.Builder babySetBuilder = ImmutableSet.builder();
        ImmutableSet.Builder teenSetBuilder = ImmutableSet.builder();
        for (ResourceLocation resourceLocation : this.listResources(resourceManager).keySet()) {
            String path = resourceLocation.m_135815_();
            String entityName = path.split("/")[2];
            if (path.contains("baby")) {
                babySetBuilder.add((Object)entityName);
                continue;
            }
            if (!path.contains("teen")) continue;
            teenSetBuilder.add((Object)entityName);
        }
        return Pair.of((Object)babySetBuilder.build(), (Object)teenSetBuilder.build());
    }

    protected void apply(Pair<Set<String>, Set<String>> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.babyTextures.clear();
        this.babyTextures.addAll((Collection)object.getFirst());
        FossilMod.LOGGER.info("Loaded {} optional baby textures", (Object)this.babyTextures.size());
        this.teenTextures.clear();
        this.teenTextures.addAll((Collection)object.getSecond());
        FossilMod.LOGGER.info("Loaded {} optional teen textures", (Object)this.teenTextures.size());
    }

    public boolean hasBabyTexture(String entityName) {
        return this.babyTextures.contains(entityName);
    }

    public boolean hasTeenTexture(String entityName) {
        return this.teenTextures.contains(entityName);
    }
}

