/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.NotNull;

public class DebugSelectionList<E extends ContainerObjectSelectionList.Entry<E>>
extends ContainerObjectSelectionList<E> {
    protected final List<Renderable> renderables = new ArrayList<Renderable>();
    protected final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    protected final int rowWidth;
    private GuiEventListener focused;

    public DebugSelectionList(Minecraft minecraft, int rowWidth, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.rowWidth = rowWidth;
    }

    public int m_5759_() {
        return this.rowWidth;
    }

    @NotNull
    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : this.listeners) {
            if (!guiEventListener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(guiEventListener);
        }
        return super.m_94729_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.listeners) {
            if (!guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.focused = guiEventListener;
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        this.focused = null;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.focused != null && this.m_7282_() && button == 0) {
            return this.focused.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected void m_239227_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_239227_(poseStack, mouseX, mouseY, partialTick);
        this.renderables.forEach(widget -> widget.m_86412_(poseStack, mouseX, mouseY, partialTick));
    }

    protected <T extends Renderable & GuiEventListener> void removeWidget(T widget) {
        this.renderables.remove(widget);
        this.listeners.remove(widget);
    }

    protected <T extends Renderable & GuiEventListener> T addWidget(T widget) {
        this.renderables.add(widget);
        this.listeners.add(widget);
        return widget;
    }
}

