/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugMoveControl;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlayerPathNavigation {
    private static final int MAX_TIME_RECOMPUTE = 20;
    protected final Player player;
    protected final Level level;
    @Nullable
    protected PlayerPath path;
    protected double speedModifier = 1.0;
    protected int tick;
    protected int lastStuckCheck;
    protected Vec3 lastStuckCheckPos = Vec3.f_82478_;
    protected Vec3i timeoutCachedNode = Vec3i.f_123288_;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 0.5f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected PlayerNodeEvaluator nodeEvaluator;
    @Nullable
    private BlockPos targetPos;
    private int reachRange;
    protected float maxVisitedNodesMultiplier = 1.0f;
    private final PlayerPathFinder pathFinder;
    private boolean isStuck;
    public boolean shouldRender;
    public String name;
    public Vec3 wantedPos;
    public Vec3 sweepStartPos;
    public Vec3 sweepWantedPos;
    public DebugMoveControl moveControl;

    public PlayerPathNavigation(Player p, Level l, String name) {
        this.player = p;
        this.level = l;
        this.name = name;
        int i = Mth.m_14143_((float)256.0f);
        this.pathFinder = this.createPathFinder(i);
        this.moveControl = new DebugMoveControl(p);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    protected PlayerPathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new PlayerNodeEvaluator();
        return new PlayerPathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    public void recomputePath() {
        if (this.level.m_46467_() - this.timeLastRecompute > 20L) {
            if (this.targetPos != null) {
                this.path = null;
                this.path = this.createPath(this.targetPos, this.reachRange);
                this.timeLastRecompute = this.level.m_46467_();
                this.hasDelayedRecomputation = false;
            }
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    @Nullable
    public PlayerPath createPath(BlockPos pos, int accuracy) {
        BlockPos blockPos;
        if (this.level.m_8055_(pos).m_60795_()) {
            blockPos = pos.m_7495_();
            while (blockPos.m_123342_() > this.level.m_141937_() && this.level.m_8055_(blockPos).m_60795_()) {
                blockPos = blockPos.m_7495_();
            }
            if (blockPos.m_123342_() > this.level.m_141937_()) {
                return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, accuracy);
            }
            while (blockPos.m_123342_() < this.level.m_151558_() && this.level.m_8055_(blockPos).m_60795_()) {
                blockPos = blockPos.m_7494_();
            }
            pos = blockPos;
        }
        if (this.level.m_8055_(pos).m_60767_().m_76333_()) {
            blockPos = pos.m_7494_();
            while (blockPos.m_123342_() < this.level.m_151558_() && this.level.m_8055_(blockPos).m_60767_().m_76333_()) {
                blockPos = blockPos.m_7494_();
            }
            return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, accuracy);
        }
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, accuracy);
    }

    @Nullable
    public PlayerPath createPath(Entity entity, int accuracy) {
        return this.createPath(entity.m_20183_(), accuracy);
    }

    @Nullable
    protected PlayerPath createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy) {
        return this.createPath(targets, regionOffset, offsetUpward, accuracy, 32.0f);
    }

    @Nullable
    protected PlayerPath createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
        int i;
        if (targets.isEmpty()) {
            return null;
        }
        if (this.player.m_20186_() < (double)this.level.m_141937_()) {
            return null;
        }
        if (!this.canUpdatePath()) {
            return null;
        }
        if (this.path != null && !this.path.isDone() && targets.contains(this.targetPos)) {
            return this.path;
        }
        BlockPos blockPos = offsetUpward ? this.player.m_20183_().m_7494_() : this.player.m_20183_();
        PathNavigationRegion pathNavigationRegion = new PathNavigationRegion(this.level, blockPos.m_7918_(-(i = (int)(followRange + (float)regionOffset)), -i, -i), blockPos.m_7918_(i, i, i));
        PlayerPath path = this.pathFinder.findPath(pathNavigationRegion, this.player, targets, followRange, accuracy, this.maxVisitedNodesMultiplier);
        if (path != null && path.getTarget() != null) {
            this.targetPos = path.getTarget();
            this.reachRange = accuracy;
            this.resetStuckTimeout();
        }
        return path;
    }

    public boolean moveTo(BlockPos targetPos) {
        PlayerPath path = this.createPath(targetPos, 1);
        return path != null && this.moveTo(path);
    }

    public boolean moveTo(@Nullable PlayerPath pathentity) {
        if (pathentity == null) {
            this.path = null;
            return false;
        }
        if (!pathentity.sameAs(this.path)) {
            this.path = pathentity;
        }
        if (this.isDone()) {
            return false;
        }
        this.trimPath();
        if (this.path.getNodeCount() <= 0) {
            return false;
        }
        this.lastStuckCheck = this.tick;
        this.lastStuckCheckPos = this.getTempMobPos();
        return true;
    }

    @Nullable
    public PlayerPath getPath() {
        return this.path;
    }

    public void tick() {
        Vec3 vec3;
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            vec3 = this.getTempMobPos();
            Vec3 vec32 = this.path.getNextEntityPos((Entity)this.player);
            if (vec3.f_82480_ > vec32.f_82480_ && !this.player.m_20096_() && Mth.m_14107_((double)vec3.f_82479_) == Mth.m_14107_((double)vec32.f_82479_) && Mth.m_14107_((double)vec3.f_82481_) == Mth.m_14107_((double)vec32.f_82481_)) {
                this.path.advance();
            }
        }
        if (this.isDone()) {
            return;
        }
        vec3 = this.path.getNextEntityPos((Entity)this.player);
        this.setNextWantedPosition(vec3.f_82479_, this.getGroundY(vec3), vec3.f_82481_);
        vec3 = this.path.getSweepEntityPos((Entity)this.player);
        this.setSweepWantedPosition(vec3.f_82479_, this.getGroundY(vec3), vec3.f_82481_);
        this.moveControl.tick();
    }

    public void setNextWantedPosition(double x, double y, double z) {
        this.wantedPos = new Vec3(x, y, z);
        this.moveControl.setWantedPosition(x, y, z, this.speedModifier);
    }

    public void setSweepWantedPosition(double x, double y, double z) {
        this.sweepWantedPos = new Vec3(x, y, z);
    }

    public void setSweepStartPos(Vec3 vec) {
        this.sweepStartPos = vec;
    }

    protected double getGroundY(Vec3 vec) {
        BlockPos blockPos = new BlockPos(vec);
        return this.level.m_8055_(blockPos.m_7495_()).m_60795_() ? vec.f_82480_ : WalkNodeEvaluator.m_77611_((BlockGetter)this.level, (BlockPos)blockPos);
    }

    protected void followThePath() {
        boolean bl;
        Vec3 vec3 = this.getTempMobPos();
        this.maxDistanceToWaypoint = PathingRenderer.getBbWidth() > 0.75f ? PathingRenderer.getBbWidth() / 2.0f : 0.75f - PathingRenderer.getBbWidth() / 2.0f;
        BlockPos vec3i = this.path.getNextNodePos();
        double d = Math.abs(this.player.m_20185_() - ((double)vec3i.m_123341_() + 0.5));
        double e = Math.abs(this.player.m_20186_() - (double)vec3i.m_123342_());
        double f = Math.abs(this.player.m_20189_() - ((double)vec3i.m_123343_() + 0.5));
        boolean bl2 = bl = d < (double)this.maxDistanceToWaypoint && f < (double)this.maxDistanceToWaypoint && e < 1.0;
        if (bl || this.canCutCorner(this.path.getNextNode().f_77282_) && this.shouldTargetNextNodeInDirection(vec3)) {
            this.path.advance();
        }
    }

    public boolean canCutCorner(BlockPathTypes pathType) {
        return pathType != BlockPathTypes.DANGER_FIRE && pathType != BlockPathTypes.DANGER_CACTUS && pathType != BlockPathTypes.DANGER_OTHER && pathType != BlockPathTypes.WALKABLE_DOOR;
    }

    private boolean shouldTargetNextNodeInDirection(Vec3 vec) {
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount()) {
            return false;
        }
        Vec3 vec3 = Vec3.m_82539_((Vec3i)this.path.getNextNodePos());
        if (!vec.m_82509_((Position)vec3, 2.0)) {
            return false;
        }
        if (this.canMoveDirectly(vec, this.path.getNextEntityPos((Entity)this.player))) {
            return true;
        }
        Vec3 vec32 = Vec3.m_82539_((Vec3i)this.path.getNodePos(this.path.getNextNodeIndex() + 1));
        Vec3 vec33 = vec32.m_82546_(vec3);
        return vec33.m_82526_(vec.m_82546_(vec3)) > 0.0;
    }

    protected void doStuckDetection(Vec3 positionVec3) {
        if (this.tick - this.lastStuckCheck > 100) {
            if (positionVec3.m_82557_(this.lastStuckCheckPos) < 2.25) {
                this.isStuck = true;
                this.stop();
            } else {
                this.isStuck = false;
            }
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = positionVec3;
        }
        if (this.path != null && !this.path.isDone()) {
            BlockPos vec3i = this.path.getNextNodePos();
            if (vec3i.equals((Object)this.timeoutCachedNode)) {
                this.timeoutTimer += Util.m_137550_() - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = vec3i;
                double d = positionVec3.m_82554_(Vec3.m_82539_((Vec3i)this.timeoutCachedNode));
                double d2 = this.timeoutLimit = this.player.m_6113_() > 0.0f ? d / (double)this.player.m_6113_() * 1000.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutPath();
            }
            this.lastTimeoutCheck = Util.m_137550_();
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = Vec3i.f_123288_;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return this.path == null || this.path.isDone();
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.path = null;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.player.m_20185_(), (double)this.getSurfaceY(), this.player.m_20189_());
    }

    private int getSurfaceY() {
        if (!this.player.m_20069_() || !this.canFloat()) {
            return Mth.m_14107_((double)(this.player.m_20186_() + 0.5));
        }
        int i = this.player.m_146904_();
        BlockState blockState = this.level.m_8055_(new BlockPos(this.player.m_20185_(), (double)i, this.player.m_20189_()));
        int j = 0;
        while (blockState.m_60713_(Blocks.f_49990_)) {
            blockState = this.level.m_8055_(new BlockPos(this.player.m_20185_(), (double)(++i), this.player.m_20189_()));
            if (++j <= 16) continue;
            return this.player.m_146904_();
        }
        return i;
    }

    protected boolean canUpdatePath() {
        return this.player.m_20096_() || this.player.m_150110_().f_35935_ || this.isInLiquid() || this.player.m_20159_();
    }

    protected boolean isInLiquid() {
        return this.player.m_20072_() || this.player.m_20077_();
    }

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int i = 0; i < this.path.getNodeCount(); ++i) {
            Node node = this.path.getNode(i);
            Node node2 = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
            BlockState blockState = this.level.m_8055_(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_));
            if (!blockState.m_204336_(BlockTags.f_144269_)) continue;
            this.path.replaceNode(i, node.m_77289_(node.f_77271_, node.f_77272_ + 1, node.f_77273_));
            if (node2 == null || node.f_77272_ < node2.f_77272_) continue;
            this.path.replaceNode(i + 1, node.m_77289_(node2.f_77271_, node.f_77272_ + 1, node2.f_77273_));
        }
    }

    protected boolean canMoveDirectly(Vec3 posVec31, Vec3 posVec32) {
        return false;
    }

    public boolean canFloat() {
        return this.nodeEvaluator.canFloat();
    }

    public boolean isStuck() {
        return this.isStuck;
    }
}

