/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneTablet
extends HangingEntity
implements EntitySpawnExtension {
    public Variant variant;

    public StoneTablet(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public StoneTablet(Level level, BlockPos blockPos, Direction direction) {
        super((EntityType)ModEntities.STONE_TABLET.get(), level, blockPos);
        ArrayList<Variant> validVariants = new ArrayList<Variant>();
        this.variant = Variant.SOCIAL;
        Variant[] variantArray = Variant.values();
        int n = variantArray.length;
        for (int i = 0; i < n; ++i) {
            Variant variant;
            this.variant = variant = variantArray[i];
            this.m_6022_(direction);
            if (!this.m_7088_()) continue;
            validVariants.add(variant);
        }
        if (!validVariants.isEmpty()) {
            this.variant = (Variant)((Object)validVariants.get(level.f_46441_.m_188503_(validVariants.size())));
        }
        this.m_6022_(direction);
    }

    public StoneTablet(Level level, BlockPos blockPos, Direction direction, Variant variant) {
        this(level, blockPos, direction);
        this.variant = variant;
        this.m_6022_(direction);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.variant.ordinal());
        compound.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.variant = Variant.values()[compound.m_128451_("Variant")];
        this.f_31699_ = Direction.m_122407_((int)compound.m_128445_("Facing"));
        this.m_6022_(this.f_31699_);
    }

    public int m_7076_() {
        if (this.variant == null) {
            return 0;
        }
        return this.variant.sizeX;
    }

    public int m_7068_() {
        if (this.variant == null) {
            return 0;
        }
        return this.variant.sizeY;
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        this.m_5496_(SoundEvents.f_12442_, 1.0f, 1.0f);
        if (brokenEntity instanceof Player) {
            Player player = (Player)brokenEntity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        this.m_19998_((ItemLike)ModItems.STONE_TABLET.get());
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12447_, 1.0f, 1.0f);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.m_130130_(this.variant.ordinal());
        buf.m_130064_(this.f_31698_);
        buf.writeByte(this.f_31699_.m_122416_());
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.variant = Variant.values()[buf.m_130242_()];
        this.f_31698_ = buf.m_130135_();
        this.m_6022_(Direction.m_122407_((int)buf.readUnsignedByte()));
    }

    public static enum Variant {
        LIGHTNING("Lightning", 32, 16, 0, 0),
        SOCIAL("Social", 16, 16, 32, 0),
        GREAT_WAR("Greatwar", 32, 32, 0, 16),
        CLOCK("clock", 32, 16, 0, 48),
        PORTAL("Portal", 32, 32, 0, 64),
        HEROBRINE("Herobrine", 32, 32, 32, 32),
        FLAT_CREEP("FlatCreep", 16, 16, 48, 0),
        ANGRY("annoyangry", 16, 16, 48, 16),
        REX_1("Rex1", 32, 32, 64, 0),
        REX_2("Rex2", 32, 16, 64, 32),
        REX_3("Rex3", 32, 16, 64, 48),
        REX_4("Rex4", 32, 32, 64, 64),
        PUZZLE("Puzzle", 32, 32, 32, 64),
        GUN_FIGHT("GunFight", 64, 32, 32, 96),
        PRINCESS("Princess", 32, 32, 0, 96),
        MOSAURUS("Mosa", 32, 16, 224, 48),
        HOLY_MOSAURUS("HolyMosasaurus", 64, 32, 160, 48),
        ANCI_TM("AnciTM", 32, 32, 96, 0),
        MOD_TM("ModTM", 16, 32, 128, 0),
        VIG_TM("VigTM", 32, 32, 144, 0),
        SABER_HUNT("SaberHunt", 32, 16, 96, 32),
        ANU_PORTAL("AnuPortal", 32, 32, 96, 48),
        ANUBITE_1("Anubite1", 16, 16, 128, 32),
        ANUBITE_2("Anubite2", 16, 16, 144, 32),
        ANUBITE_3("Anubite3", 16, 16, 160, 32),
        ANUBITE_4("Anubite4", 16, 16, 176, 32),
        SARCOPHAGUS_OPEN("sarcophagus_open", 32, 32, 128, 48),
        SARCOPHAGUS_KILL("sarcophagus_kill", 32, 32, 96, 80),
        DEAD_ANU("deadAnu", 32, 32, 128, 80);

        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private Variant(String title, int xSize, int ySize, int textureX, int textureY) {
            this.title = title;
            this.sizeX = xSize;
            this.sizeY = ySize;
            this.offsetX = textureX;
            this.offsetY = textureY;
        }
    }
}

