/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayGoal
extends Goal {
    protected static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    protected long lastCanUseCheck;
    protected final Prehistoric dino;
    protected final double speedModifier;
    @Nullable
    protected Path path;
    protected ToyBase target;
    protected long attackEndTick = -1L;
    protected long attackDamageTick = -1L;

    public PlayGoal(Prehistoric dino, double speedModifier) {
        this.dino = dino;
        this.speedModifier = speedModifier;
    }

    public boolean m_8036_() {
        long l = this.dino.f_19853_.m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        if (this.dino.isFleeing() || this.dino.m_5448_() != null || this.dino.getCurrentOrder() != OrderType.WANDER) {
            return false;
        }
        if (this.dino.moodSystem.getPlayingCooldown() > 0 || this.dino.moodSystem.getMood() >= 100) {
            return false;
        }
        this.target = this.findPlayTarget();
        if (this.target == null) {
            return false;
        }
        this.path = this.dino.m_21573_().m_6570_((Entity)this.target, 0);
        if (this.path != null) {
            return true;
        }
        return Util.canReachPrey(this.dino, this.target);
    }

    public boolean m_8045_() {
        if (this.dino.f_19853_.m_46467_() < this.attackEndTick) {
            return true;
        }
        ToyBase currentToyTarget = this.dino.moodSystem.getToyTarget();
        if (currentToyTarget == null) {
            currentToyTarget = this.target;
        }
        if (currentToyTarget == null || this.dino.moodSystem.getPlayingCooldown() > 0) {
            return false;
        }
        double d = this.getFollowDistance();
        if (this.dino.m_20280_(currentToyTarget) > d * d || this.dino.getCurrentOrder() != OrderType.WANDER) {
            return false;
        }
        this.dino.moodSystem.setToyTarget(currentToyTarget);
        return true;
    }

    public void m_8056_() {
        this.dino.m_21573_().m_26536_(this.path, this.speedModifier);
        this.dino.moodSystem.setToyTarget(this.target);
        this.attackEndTick = -1L;
        this.attackDamageTick = -1L;
    }

    public void m_8041_() {
        this.dino.moodSystem.setToyTarget(null);
        this.target = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        this.dino.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (this.dino.m_21573_().m_26571_() && !Util.canReachPrey(this.dino, this.target)) {
            this.dino.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.checkAndPerformAttack(this.target);
    }

    protected void checkAndPerformAttack(ToyBase target) {
        long currentTime = this.dino.f_19853_.m_46467_();
        if (Util.canReachPrey(this.dino, target)) {
            if (currentTime > this.attackEndTick + 20L) {
                ServerAnimationInfo animation = this.dino.startAttack();
                this.attackDamageTick = (long)((double)currentTime + animation.actionDelay);
                this.attackEndTick = (long)((double)currentTime + animation.animation.length());
                if (this.attackDamageTick > this.attackEndTick) {
                    this.attackDamageTick = this.attackEndTick;
                }
                this.dino.m_21573_().m_26573_();
            }
            if (this.attackDamageTick > 0L && currentTime == this.attackDamageTick) {
                target.m_6469_(DamageSource.m_19370_((LivingEntity)this.dino), 0.0f);
                this.attackDamageTick = -1L;
            }
        }
    }

    protected ToyBase findPlayTarget() {
        return Util.getNearestEntity(ToyBase.class, (Mob)this.dino, this.getTargetSearchArea(this.getFollowDistance()), toyBase -> true);
    }

    @NotNull
    protected AABB getTargetSearchArea(double targetDistance) {
        double yDist = 4.0;
        if (this.dino instanceof PrehistoricFlying || this.dino instanceof PrehistoricSwimming && this.dino.m_6069_()) {
            yDist = targetDistance;
        }
        return this.dino.m_20191_().m_82377_(targetDistance, yDist, targetDistance);
    }

    protected double getFollowDistance() {
        return this.dino.m_21133_(Attributes.f_22277_) * 2.0;
    }
}

