/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.control;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;

public class CustomSwimMoveControl<T extends Prehistoric>
extends SmoothSwimmingMoveControl {
    private final T mob;

    public CustomSwimMoveControl(T mob) {
        super(mob, 85, 10, 0.1f, 0.1f, true);
        this.mob = mob;
    }

    public void m_8126_() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.mob.m_21573_().m_26571_()) {
            double x = this.f_24975_ - this.mob.m_20185_();
            double y = this.f_24976_ - this.mob.m_20186_();
            double z = this.f_24977_ - this.mob.m_20189_();
            double horizontalDist = x * x + z * z;
            double dist = horizontalDist + y * y;
            if (dist < 2.5E-7) {
                this.mob.m_21564_(0.0f);
            } else {
                if (horizontalDist > 0.3) {
                    float h = Util.clampTo360(Util.yawToYRot(Mth.m_14136_((double)z, (double)x) * 57.2957763671875));
                    float g = this.m_24991_(Util.clampTo360(this.mob.m_146908_()), h, 5.0f);
                    this.mob.m_146922_(g);
                    ((Prehistoric)this.mob).f_20883_ = this.mob.m_146908_();
                    ((Prehistoric)this.mob).f_20885_ = this.mob.m_146908_();
                }
                if (this.mob.m_20069_()) {
                    float k;
                    float i = (float)((SwimmingAnimal)this.mob).swimSpeed();
                    if (horizontalDist < 4.0 && (double)i > 0.12) {
                        i *= 0.5f;
                    }
                    this.mob.m_7910_(i);
                    double horDist = Math.sqrt(x * x + z * z);
                    if (Math.abs(y) > 1.0E-5 || Math.abs(horDist) > 1.0E-5) {
                        k = (float)(-Mth.m_14136_((double)y, (double)horDist) * 57.2957763671875) + 90.0f;
                        k = Mth.m_14036_((float)k, (float)30.0f, (float)150.0f);
                        float g = this.m_24991_(this.mob.m_146909_() + 90.0f, k, 5.0f);
                        this.mob.m_146926_(g - 90.0f);
                    }
                    k = Mth.m_14089_((float)(this.mob.m_146909_() * ((float)Math.PI / 180)));
                    float l = Mth.m_14031_((float)(this.mob.m_146909_() * ((float)Math.PI / 180)));
                    ((Prehistoric)this.mob).f_20902_ = k * i;
                    ((Prehistoric)this.mob).f_20901_ = -l * i;
                    if (((SwimmingAnimal)this.mob).isAmphibious() && ((Prehistoric)this.mob).f_19853_.m_6425_(new BlockPos(this.f_24975_, this.f_24976_, this.f_24977_)).m_76178_()) {
                        this.mob.m_21569_().m_24901_();
                        this.f_24981_ = MoveControl.Operation.JUMPING;
                    }
                }
            }
        } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
            this.mob.m_7910_((float)((SwimmingAnimal)this.mob).swimSpeed());
            if (!this.mob.m_20069_() || this.mob.m_20184_().f_82480_ <= 0.0) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        } else {
            this.mob.m_7910_(0.0f);
            this.mob.m_21570_(0.0f);
            this.mob.m_21567_(0.0f);
            this.mob.m_21564_(0.0f);
        }
    }
}

