/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrilobiteNodeEvaluator
extends NodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    @NotNull
    public Node m_7171_() {
        BlockPos.MutableBlockPos mutableBlockPos = this.f_77313_.m_20183_().m_122032_();
        int i = this.f_77313_.m_146904_();
        if (this.f_77313_.m_20069_()) {
            while (mutableBlockPos.m_123342_() > this.f_77312_.m_141937_() && this.f_77312_.m_8055_((BlockPos)mutableBlockPos).m_60647_((BlockGetter)this.f_77312_, (BlockPos)mutableBlockPos, PathComputationType.WATER)) {
                mutableBlockPos.m_122184_(0, -1, 0);
            }
        } else {
            Node node = this.m_5676_(mutableBlockPos.m_123341_(), i, mutableBlockPos.m_123343_());
            node.f_77282_ = this.getBlockPathType(this.f_77313_, node.m_77288_());
            node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
            return node;
        }
        i = mutableBlockPos.m_7494_().m_123342_();
        BlockPos blockPos = this.f_77313_.m_20183_();
        BlockPathTypes blockPathTypes = this.getCachedBlockType(this.f_77313_, blockPos.m_123341_(), i, blockPos.m_123343_());
        if (this.f_77313_.m_21439_(blockPathTypes) < 0.0f) {
            AABB aABB = this.f_77313_.m_20191_();
            if (this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82288_, (double)i, aABB.f_82290_)) || this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82288_, (double)i, aABB.f_82293_)) || this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82291_, (double)i, aABB.f_82290_)) || this.hasPositiveMalus((BlockPos)mutableBlockPos.m_122169_(aABB.f_82291_, (double)i, aABB.f_82293_))) {
                Node node = this.m_77349_((BlockPos)mutableBlockPos);
                node.f_77282_ = this.getBlockPathType(this.f_77313_, node.m_77288_());
                node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
                return node;
            }
        }
        Node node = this.m_5676_(blockPos.m_123341_(), i, blockPos.m_123343_());
        node.f_77282_ = this.getBlockPathType(this.f_77313_, node.m_77288_());
        node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
        return node;
    }

    public final boolean hasPositiveMalus(BlockPos pos) {
        BlockPathTypes blockPathTypes = this.getBlockPathType(this.f_77313_, pos);
        return this.f_77313_.m_21439_(blockPathTypes) >= 0.0f;
    }

    @NotNull
    public Target m_7568_(double x, double y, double z) {
        return new Target(this.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
    }

    public int m_6065_(Node[] nodes, Node node) {
        Node node9;
        Node node8;
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        double d;
        Node node2;
        int i = 0;
        int j = 0;
        BlockPathTypes blockPathTypes = this.getCachedBlockType(this.f_77313_, node.f_77271_, node.f_77272_ + 1, node.f_77273_);
        BlockPathTypes blockPathTypes2 = this.getCachedBlockType(this.f_77313_, node.f_77271_, node.f_77272_, node.f_77273_);
        if (this.f_77313_.m_21439_(blockPathTypes) >= 0.0f && blockPathTypes2 != BlockPathTypes.STICKY_HONEY) {
            j = Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.f_19793_));
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(node.f_77271_, node.f_77272_, node.f_77273_ + 1, j, d = this.getFloorLevel(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_)), Direction.SOUTH, blockPathTypes2), node)) {
            nodes[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(node.f_77271_ - 1, node.f_77272_, node.f_77273_, j, d, Direction.WEST, blockPathTypes2), node)) {
            nodes[i++] = node3;
        }
        if (this.isNeighborValid(node4 = this.findAcceptedNode(node.f_77271_ + 1, node.f_77272_, node.f_77273_, j, d, Direction.EAST, blockPathTypes2), node)) {
            nodes[i++] = node4;
        }
        if (this.isNeighborValid(node5 = this.findAcceptedNode(node.f_77271_, node.f_77272_, node.f_77273_ - 1, j, d, Direction.NORTH, blockPathTypes2), node)) {
            nodes[i++] = node5;
        }
        if (this.isDiagonalValid(node, node3, node5, node6 = this.findAcceptedNode(node.f_77271_ - 1, node.f_77272_, node.f_77273_ - 1, j, d, Direction.NORTH, blockPathTypes2))) {
            nodes[i++] = node6;
        }
        if (this.isDiagonalValid(node, node4, node5, node7 = this.findAcceptedNode(node.f_77271_ + 1, node.f_77272_, node.f_77273_ - 1, j, d, Direction.NORTH, blockPathTypes2))) {
            nodes[i++] = node7;
        }
        if (this.isDiagonalValid(node, node3, node2, node8 = this.findAcceptedNode(node.f_77271_ - 1, node.f_77272_, node.f_77273_ + 1, j, d, Direction.SOUTH, blockPathTypes2))) {
            nodes[i++] = node8;
        }
        if (this.isDiagonalValid(node, node4, node2, node9 = this.findAcceptedNode(node.f_77271_ + 1, node.f_77272_, node.f_77273_ + 1, j, d, Direction.SOUTH, blockPathTypes2))) {
            nodes[i++] = node9;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable Node node, Node node2) {
        return node != null && !node.f_77279_ && (node.f_77281_ >= 0.0f || node2.f_77281_ < 0.0f);
    }

    protected boolean isDiagonalValid(Node node, @Nullable Node node2, @Nullable Node node3, @Nullable Node node4) {
        if (node4 == null || node3 == null || node2 == null) {
            return false;
        }
        if (node4.f_77279_) {
            return false;
        }
        if (node3.f_77272_ > node.f_77272_ || node2.f_77272_ > node.f_77272_) {
            return false;
        }
        boolean bl = node3.f_77282_ == BlockPathTypes.FENCE && node2.f_77282_ == BlockPathTypes.FENCE && (double)this.f_77313_.m_20205_() < 0.5;
        return node4.f_77281_ >= 0.0f && (node3.f_77272_ < node.f_77272_ || node3.f_77281_ >= 0.0f || bl) && (node2.f_77272_ < node.f_77272_ || node2.f_77281_ >= 0.0f || bl);
    }

    protected double getFloorLevel(BlockPos pos) {
        return TrilobiteNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, pos);
    }

    public static double getFloorLevel(BlockGetter level, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        VoxelShape voxelShape = level.m_8055_(blockPos).m_60812_(level, blockPos);
        return (double)blockPos.m_123342_() + (voxelShape.m_83281_() ? 0.0 : voxelShape.m_83297_(Direction.Axis.Y));
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int i, double d, Direction direction, BlockPathTypes original) {
        Node node = null;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        double e = this.getFloorLevel((BlockPos)mutableBlockPos.m_122178_(x, y, z));
        if (e - d > 1.125) {
            return null;
        }
        BlockPathTypes type = this.getCachedBlockType(this.f_77313_, x, y, z);
        float f = this.f_77313_.m_21439_(type);
        double g = (double)this.f_77313_.m_20205_() / 2.0;
        if (f >= 0.0f) {
            node = this.m_5676_(x, y, z);
            node.f_77282_ = type;
            node.f_77281_ = Math.max(node.f_77281_, f);
        }
        if (type != BlockPathTypes.WALKABLE) {
            double j;
            double h;
            AABB aABB;
            if ((node == null || node.f_77281_ < 0.0f) && i > 0 && (node = this.findAcceptedNode(x, y + 1, z, i - 1, d, direction, original)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && this.f_77313_.m_20205_() < 1.0f && this.hasCollisions(aABB = new AABB((h = (double)(x - direction.m_122429_()) + 0.5) - g, TrilobiteNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, (BlockPos)mutableBlockPos.m_122169_(h, (double)(y + 1), j = (double)(z - direction.m_122431_()) + 0.5)) + 0.001, j - g, h + g, (double)this.f_77313_.m_20206_() + TrilobiteNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, (BlockPos)mutableBlockPos.m_122178_(node.f_77271_, node.f_77272_, node.f_77273_)) - 0.002, j + g))) {
                node = null;
            }
            if (type == BlockPathTypes.WATER) {
                if (this.getCachedBlockType(this.f_77313_, x, y - 1, z) != BlockPathTypes.WATER) {
                    return node;
                }
                while (y > this.f_77313_.f_19853_.m_141937_()) {
                    if ((type = this.getCachedBlockType(this.f_77313_, x, --y, z)) != BlockPathTypes.WATER) {
                        return node;
                    }
                    node = this.m_5676_(x, y, z);
                    node.f_77282_ = type;
                    node.f_77281_ = Math.max(node.f_77281_, this.f_77313_.m_21439_(type));
                }
            }
            if (type == BlockPathTypes.OPEN) {
                int k = 0;
                int l = y;
                while (type == BlockPathTypes.OPEN) {
                    if (--y < this.f_77313_.f_19853_.m_141937_()) {
                        Node node2 = this.m_5676_(x, l, z);
                        node2.f_77282_ = BlockPathTypes.BLOCKED;
                        node2.f_77281_ = -1.0f;
                        return node2;
                    }
                    if (k++ >= this.f_77313_.m_6056_()) {
                        Node node2 = this.m_5676_(x, y, z);
                        node2.f_77282_ = BlockPathTypes.BLOCKED;
                        node2.f_77281_ = -1.0f;
                        return node2;
                    }
                    type = this.getCachedBlockType(this.f_77313_, x, y, z);
                    f = this.f_77313_.m_21439_(type);
                    if (type != BlockPathTypes.OPEN && f >= 0.0f) {
                        node = this.m_5676_(x, y, z);
                        node.f_77282_ = type;
                        node.f_77281_ = Math.max(node.f_77281_, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    Node node2 = this.m_5676_(x, y, z);
                    node2.f_77282_ = BlockPathTypes.BLOCKED;
                    node2.f_77281_ = -1.0f;
                    return node2;
                }
            }
        }
        return node;
    }

    private boolean hasCollisions(AABB aABB) {
        return this.collisionCache.computeIfAbsent((Object)aABB, object -> !this.f_77312_.m_45756_((Entity)this.f_77313_, aABB));
    }

    private BlockPathTypes getBlockPathType(Mob entityliving, BlockPos pos) {
        return this.getCachedBlockType(entityliving, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    protected BlockPathTypes getCachedBlockType(Mob entity, int x, int y, int z) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)x, (int)y, (int)z), l -> this.m_7209_((BlockGetter)this.f_77312_, x, y, z, entity, this.f_77315_, this.f_77316_, this.f_77317_, false, false));
    }

    @NotNull
    public BlockPathTypes m_7209_(BlockGetter blockaccess, int x, int y, int z, Mob entityliving, int xSize, int ySize, int zSize, boolean canBreakDoors, boolean canEnterDoors) {
        EnumSet<BlockPathTypes> enumSet = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockPathTypes = BlockPathTypes.BLOCKED;
        blockPathTypes = this.getBlockPathTypes(blockaccess, x, y, z, xSize, ySize, zSize, enumSet, blockPathTypes);
        BlockPathTypes result = BlockPathTypes.BLOCKED;
        for (BlockPathTypes tested : enumSet) {
            if (entityliving.m_21439_(tested) < 0.0f) {
                return tested;
            }
            if (!(entityliving.m_21439_(tested) >= entityliving.m_21439_(result))) continue;
            result = tested;
        }
        return blockPathTypes == BlockPathTypes.OPEN && entityliving.m_21439_(result) == 0.0f && xSize <= 1 ? BlockPathTypes.OPEN : result;
    }

    public BlockPathTypes getBlockPathTypes(BlockGetter level, int x, int y, int z, int xSize, int ySize, int zSize, Set<BlockPathTypes> nodeTypeEnum, BlockPathTypes nodeType) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    BlockPathTypes blockPathTypes = this.m_8086_(level, l, m, n);
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = blockPathTypes;
                    }
                    nodeTypeEnum.add(blockPathTypes);
                }
            }
        }
        return nodeType;
    }

    @NotNull
    public BlockPathTypes m_8086_(BlockGetter level, int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        BlockPathTypes type = TrilobiteNodeEvaluator.getBlockPathTypeRaw(level, (BlockPos)pos);
        if (type == BlockPathTypes.OPEN && j >= level.m_141937_() + 1) {
            BlockPathTypes below = TrilobiteNodeEvaluator.getBlockPathTypeRaw(level, (BlockPos)pos.m_122178_(i, j - 1, k));
            if (below == BlockPathTypes.DAMAGE_FIRE) {
                type = BlockPathTypes.DAMAGE_FIRE;
            } else if (below != BlockPathTypes.OPEN) {
                type = BlockPathTypes.WALKABLE;
            }
        }
        return type;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        if (fluidState.m_205070_(FluidTags.f_13131_)) {
            return BlockPathTypes.OPEN;
        }
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60713_(Blocks.f_50450_)) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        return BlockPathTypes.BLOCKED;
    }
}

