/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.BakedAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfo;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.loading.object.BakedAnimations;

public class ClientAnimationInfoLoader
extends AnimationInfoLoader<ClientAnimationInfo> {
    private static final BakedAnimationInfo<ClientAnimationInfo> EMPTY = new BakedAnimationInfo(Object2ObjectMaps.emptyMap());
    public static final ClientAnimationInfoLoader INSTANCE = new ClientAnimationInfoLoader(new GsonBuilder().create());
    private Map<ResourceLocation, BakedAnimationInfo<ClientAnimationInfo>> clientAnimationInfos = ImmutableMap.of();

    public ClientAnimationInfoLoader(Gson gson) {
        super(gson, "animations/entity/data");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        Object2ObjectOpenHashMap data = new Object2ObjectOpenHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : jsons.entrySet()) {
            JsonElement jsonElement = fileEntry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            if (!fileEntry.getKey().m_135827_().equals("fossil")) continue;
            ImmutableMap.Builder innerBuilder = ImmutableMap.builder();
            for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)root, (String)"animations").getAsJsonObject().entrySet()) {
                JsonObject animationObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                double blockSpeed = animationObj.has("blocks_per_second") ? GsonHelper.m_144784_((JsonObject)animationObj, (String)"blocks_per_second") : 0.0;
                innerBuilder.put((Object)((String)entry.getKey()), (Object)blockSpeed);
            }
            ResourceLocation path = FossilMod.location("animations/entity/" + fileEntry.getKey().m_135815_() + ".animation.json");
            data.put(path, innerBuilder.build());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry fileEntry : GeckoLibCache.getBakedAnimations().entrySet()) {
            if (!((ResourceLocation)fileEntry.getKey()).m_135827_().equals("fossil")) continue;
            Object2ObjectOpenHashMap bakedMap = new Object2ObjectOpenHashMap();
            for (Map.Entry entry : ((BakedAnimations)fileEntry.getValue()).animations().entrySet()) {
                double blocksPerSecond = ((Map)data.getOrDefault(fileEntry.getKey(), new HashMap())).getOrDefault(entry.getKey(), 0.0);
                bakedMap.put((String)entry.getKey(), new ClientAnimationInfo((Animation)entry.getValue(), blocksPerSecond));
            }
            builder.put((Object)((ResourceLocation)fileEntry.getKey()), new BakedAnimationInfo(bakedMap));
        }
        this.clientAnimationInfos = builder.build();
        FossilMod.LOGGER.info("Loaded {} client animations for {} entities", (Object)this.clientAnimationInfos.values().stream().map(info -> info.animations().size()).reduce(Integer::sum).orElse(0), (Object)this.clientAnimationInfos.size());
        AnimationCategoryLoader.CLIENT.apply(this.clientAnimationInfos);
    }

    @Override
    public Map<ResourceLocation, BakedAnimationInfo<ClientAnimationInfo>> getAnimationInfos() {
        return this.clientAnimationInfos;
    }

    @Override
    public BakedAnimationInfo<ClientAnimationInfo> getAnimations(ResourceLocation animationFile) {
        return this.clientAnimationInfos.getOrDefault(animationFile, EMPTY);
    }
}

