/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.fish;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Nautilus
extends PrehistoricFish {
    private static final String SWIM_BACKWARDS = "animation.nautilus.swim_backwards";
    private static final String SWIM_FORWARDS = "animation.nautilus.swim_forwards";
    private static final String SHELL_RETRACT = "animation.nautilus.shell_retract";
    private static final String SHELL_EMERGE = "animation.nautilus.shell_emerge";
    private static final RawAnimation SHELL_CLOSE = RawAnimation.begin().thenPlay("animation.nautilus.shell_retract");
    private static final RawAnimation SHELL_OPEN = RawAnimation.begin().thenPlay("animation.nautilus.shell_emerge");
    private static final EntityDataAccessor<Boolean> IS_IN_SHELL = SynchedEntityData.m_135353_(Nautilus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions SHELL_DIMENSIONS = EntityDimensions.m_20398_((float)1.0f, (float)0.5f);
    private float ticksUntilShellUpdate = 0.0f;
    private float ticksInShell = -1.0f;

    public Nautilus(EntityType<Nautilus> entityType, Level level) {
        super(entityType, level);
    }

    private static boolean getsScaredBy(Entity entity) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            return true;
        }
        if (entity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)entity;
            return prehistoric.data().diet().canEat(FoodType.FISH);
        }
        if (entity instanceof Nautilus) {
            return false;
        }
        return (double)entity.m_20205_() >= 1.2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_IN_SHELL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("InShell", this.isInShell());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hideInShell(compound.m_128471_("InShell"));
    }

    @Override
    @NotNull
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.NAUTILUS;
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.isInShell() && this.m_20069_()) {
            if (!this.f_19853_.f_46443_) {
                this.m_20334_(0.0, -0.05, 0.0);
                this.m_6478_(MoverType.SELF, this.m_20184_());
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.ticksUntilShellUpdate > 0.0f) {
                this.ticksUntilShellUpdate -= 1.0f;
            }
            if (this.ticksInShell > -1.0f) {
                this.ticksInShell += 1.0f;
            }
            if (this.isInShell() && this.ticksInShell > 20.0f) {
                this.m_183634_();
            }
            if (this.ticksUntilShellUpdate == 0.0f) {
                List nearbyMobs = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 2.0, 2.0), Nautilus::getsScaredBy);
                if (!nearbyMobs.isEmpty()) {
                    this.closeShell();
                }
                if (this.shouldBeBeached()) {
                    this.closeShell();
                }
                if (this.ticksInShell > 20.0f && this.ticksUntilShellUpdate == 0.0f && this.isInShell() && nearbyMobs.isEmpty()) {
                    this.openShell();
                }
            }
        }
        if (this.f_19797_ % 20 == 0) {
            Vec3 oldPos = this.m_20182_();
            this.m_6210_();
            this.m_6034_(this.m_20185_(), oldPos.f_82480_, this.m_20189_());
        }
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return this.shouldBeBeached() ? SHELL_DIMENSIONS : super.m_6972_(pose);
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42484_)) {
            if (!this.f_19853_.f_46443_) {
                this.openShell();
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6229_(int airSupply) {
        if (!this.isInShell()) {
            super.m_6229_(airSupply);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (amount > 0.0f && this.isInShell() && this.ticksInShell > 20.0f && source.m_7639_() != null) {
            this.m_5496_(SoundEvents.f_12018_, 1.0f, this.f_19796_.m_188501_() + 0.8f);
            if (this.m_20202_() != null) {
                return super.m_6469_(source, amount);
            }
            return false;
        }
        this.closeShell();
        return super.m_6469_(source, amount);
    }

    public boolean m_6063_() {
        return this.isInShell();
    }

    private boolean shouldBeBeached() {
        if (this.m_20069_() || this.f_19853_.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        return this.m_20096_() || !this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_);
    }

    public boolean isInShell() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_SHELL);
    }

    public void hideInShell(boolean close) {
        if (close) {
            this.closeShell();
        } else {
            this.openShell();
        }
    }

    public void closeShell() {
        if (!((Boolean)this.f_19804_.m_135370_(IS_IN_SHELL)).booleanValue()) {
            this.ticksInShell = 0.0f;
        }
        this.f_19804_.m_135381_(IS_IN_SHELL, (Object)true);
        this.ticksUntilShellUpdate = 60.0f;
    }

    public void openShell() {
        this.f_19804_.m_135381_(IS_IN_SHELL, (Object)false);
        this.ticksUntilShellUpdate = 60.0f;
        this.ticksInShell = -1.0f;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new PausableAnimationController<Nautilus>(this, "Movement/Idle", 20, event -> {
            AnimationController ctrl = event.getController();
            if (this.shouldBeBeached()) {
                ctrl.setAnimation(RawAnimation.begin().thenPlay(this.nextBeachedAnimation().animation.name()));
            } else {
                if (this.isInShell() && this.m_20069_()) {
                    return PlayState.STOP;
                }
                if (event.isMoving()) {
                    ctrl.setAnimation(RawAnimation.begin().thenPlay(this.nextWalkingAnimation().animation.name()));
                } else {
                    ctrl.setAnimation(RawAnimation.begin().thenPlay(this.nextIdleAnimation().animation.name()));
                }
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new PausableAnimationController<Nautilus>(this, "Shell", 4, this::shellPredicate)});
    }

    private PlayState shellPredicate(AnimationState<Nautilus> state) {
        if (((Nautilus)state.getAnimatable()).isInShell()) {
            state.setAnimation(SHELL_CLOSE);
        } else if (state.isCurrentAnimation(SHELL_CLOSE)) {
            state.setAnimation(SHELL_OPEN);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        if (category == AnimationCategory.SWIM) {
            return this.getAllAnimations().get(SWIM_BACKWARDS);
        }
        if (category == AnimationCategory.SWIM_FAST) {
            return this.getAllAnimations().get(SWIM_FORWARDS);
        }
        return super.getAnimation(category);
    }
}

