/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.advancements;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ImplantEmbryoTrigger;
import com.github.teamfossilsarcheology.fossil.advancements.IncubateEggTrigger;
import com.github.teamfossilsarcheology.fossil.advancements.OpenSarcophagusTrigger;
import com.github.teamfossilsarcheology.fossil.advancements.ScarabTameTrigger;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.tags.ModItemTags;
import com.github.teamfossilsarcheology.fossil.world.dimension.ModDimensions;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class FossilAdvancements
implements Consumer<Consumer<Advancement>> {
    @Override
    public void accept(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)ModItems.BIO_FOSSIL.get(), (Component)Component.m_237115_((String)"advancements.fossil.root.title"), (Component)Component.m_237115_((String)"advancements.fossil.root.description"), FossilMod.location("textures/block/ancient_stone_bricks.png"), FrameType.TASK, true, false, false).m_138386_("requirement", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50091_})).m_138389_(consumer, "fossil:fossil/root");
        Advancement breakFossil = this.simple(root, "break_fossil", consumer, ModItems.RELIC_SCRAP, ModItems.BIO_FOSSIL, ModItems.PlANT_FOSSIL, ModItems.SHALE_FOSSIL, ModBlocks.SKULL_BLOCK);
        Advancement analyzer = this.simple(breakFossil, consumer, ModBlocks.ANALYZER);
        Advancement fossilSeed = this.tag((ItemLike)ModItems.FERN_SEED_FOSSIL.get(), ModItemTags.FOSSIL_SEEDS, analyzer, consumer);
        Advancement restoredSeed = this.tag((ItemLike)ModItems.FERN_SEED.get(), ModItemTags.RESTORED_SEEDS, fossilSeed, consumer);
        Advancement figurine = this.tag((ItemLike)ModBlocks.STEVE_FIGURINE_DESTROYED.get(), ModItemTags.FIGURINES, breakFossil, consumer);
        Advancement anuLair = this.other(figurine, ModBlocks.ANU_STATUE, "anu_lair", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(ModDimensions.ANU_LAIR), consumer);
        Advancement anubite = this.other(anuLair, ModBlocks.ANUBITE_STATUE, "anubite", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.ANUBITE.get())), consumer);
        Advancement sarcophagus = this.other(anuLair, ModBlocks.SARCOPHAGUS, "sarcophagus", (CriterionTriggerInstance)OpenSarcophagusTrigger.TriggerInstance.useScarab(), consumer);
        Advancement killAnu = this.other(sarcophagus, ModItems.ANCIENT_KEY, "kill_anu", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.ANU_BOSS.get())), consumer);
        Advancement ancientClock = this.simple(killAnu, consumer, ModItems.ANCIENT_CLOCK);
        Advancement frozenMeat = this.simple(breakFossil, consumer, ModItems.FROZEN_MEAT);
        Advancement scarabGem = this.simple(breakFossil, consumer, ModItems.SCARAB_GEM);
        Advancement scarabTame = this.other(scarabGem, ModItems.AQUATIC_SCARAB_GEM, "scarab_tame", (CriterionTriggerInstance)ScarabTameTrigger.TriggerInstance.useScarab(), consumer);
        Advancement stoneTablet = this.simple(analyzer, consumer, ModItems.STONE_TABLET);
        Advancement tarDrop = this.simple(breakFossil, consumer, ModItems.TAR_DROP);
        Advancement tarFossil = this.simple(tarDrop, consumer, ModItems.TAR_FOSSIL);
        Advancement brokenSword = this.simple(root, consumer, ModItems.BROKEN_SWORD, ModItems.BROKEN_HELMET);
        Advancement worktable = this.simple(brokenSword, consumer, ModBlocks.WORKTABLE);
        Advancement ancientSword = this.simple(worktable, consumer, ModItems.ANCIENT_SWORD, ModItems.ANCIENT_HELMET);
        Advancement dna = this.tag((ItemLike)PrehistoricEntityInfo.TRICERATOPS.dnaItem, ModItemTags.DNA, analyzer, consumer);
        Advancement cultureVat = this.simple(dna, consumer, ModBlocks.CULTURE_VAT);
        Advancement failuresaurus = this.other(cultureVat, ModItems.FAILURESAURUS_FLESH, "failuresaurus", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_156066_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.FAILURESAURUS.get()).m_36662_()), consumer);
        Advancement embryo = this.tag((ItemLike)PrehistoricEntityInfo.MAMMOTH.embryoItem, ModItemTags.EMBRYOS, cultureVat, consumer);
        Advancement dinoEgg = this.tag((ItemLike)PrehistoricEntityInfo.TRICERATOPS.eggItem, ModItemTags.ALL_EGGS, cultureVat, consumer, "dino_eggs");
        Advancement dinopedia = this.simple(dinoEgg, consumer, ModItems.DINOPEDIA);
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138371_((ItemLike)PrehistoricEntityInfo.TYRANNOSAURUS.eggItem, this.title("all_eggs"), this.description("all_eggs"), null, FrameType.CHALLENGE, true, true, false).m_138398_(dinoEgg).m_138354_(AdvancementRewards.Builder.m_10005_((int)1000));
        for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
            if (prehistoricEntityInfo.eggItem == null && prehistoricEntityInfo.cultivatedBirdEggItem == null) continue;
            builder.m_138386_(this.key(prehistoricEntityInfo.entityType()).m_135815_(), (CriterionTriggerInstance)IncubateEggTrigger.TriggerInstance.incubateEgg(prehistoricEntityInfo.entityType()));
        }
        builder.m_138389_(consumer, "fossil:fossil/all_eggs");
        builder = Advancement.Builder.m_138353_().m_138371_((ItemLike)PrehistoricEntityInfo.MAMMOTH.embryoItem, this.title("all_embryos"), this.description("all_embryos"), null, FrameType.CHALLENGE, true, true, false).m_138398_(embryo).m_138354_(AdvancementRewards.Builder.m_10005_((int)500));
        for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
            if (prehistoricEntityInfo.embryoItem == null) continue;
            builder.m_138386_(this.key(prehistoricEntityInfo.embryoItem).m_135815_(), (CriterionTriggerInstance)ImplantEmbryoTrigger.TriggerInstance.implantEmbryo(prehistoricEntityInfo.embryoItem));
        }
        for (Enum enum_ : VanillaEntityInfo.values()) {
            if (((VanillaEntityInfo)enum_).embryoItem == null) continue;
            builder.m_138386_(this.key(((VanillaEntityInfo)enum_).embryoItem).m_135815_(), (CriterionTriggerInstance)ImplantEmbryoTrigger.TriggerInstance.implantEmbryo(((VanillaEntityInfo)enum_).embryoItem));
        }
        builder.m_138389_(consumer, "fossil:fossil/all_embryos");
    }

    private Advancement other(Advancement parent, RegistrySupplier<? extends ItemLike> item, String key, CriterionTriggerInstance trigger, Consumer<Advancement> consumer) {
        return Advancement.Builder.m_138353_().m_138371_((ItemLike)item.get(), this.title(key), this.description(key), null, FrameType.TASK, true, true, false).m_138398_(parent).m_138386_("requirement", trigger).m_138389_(consumer, "fossil:fossil/" + key);
    }

    private Advancement simple(Advancement parent, String key, Consumer<Advancement> consumer, ItemLike ... items) {
        ItemLike item = items[0];
        Advancement.Builder builder = Advancement.Builder.m_138353_().m_138371_(item, this.title(key), this.description(key), null, FrameType.TASK, true, true, false).m_138398_(parent).m_138360_(RequirementsStrategy.f_15979_);
        for (int i = 0; i < items.length; ++i) {
            builder.m_138386_(this.key(items[i].m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{items[i]}));
        }
        return builder.m_138389_(consumer, "fossil:fossil/" + key);
    }

    @SafeVarargs
    private Advancement simple(Advancement parent, String key, Consumer<Advancement> consumer, RegistrySupplier<? extends ItemLike> ... items) {
        return this.simple(parent, key, consumer, (ItemLike[])Arrays.stream(items).map(Supplier::get).toArray(ItemLike[]::new));
    }

    @SafeVarargs
    private Advancement simple(Advancement parent, Consumer<Advancement> consumer, RegistrySupplier<? extends ItemLike> ... items) {
        return this.simple(parent, this.key(((ItemLike)items[0].get()).m_5456_()).m_135815_(), consumer, (ItemLike[])Arrays.stream(items).map(Supplier::get).toArray(ItemLike[]::new));
    }

    private Advancement tag(ItemLike item, TagKey<Item> tag, Advancement parent, Consumer<Advancement> consumer, String key) {
        return Advancement.Builder.m_138353_().m_138371_(item, this.title(key), this.description(key), null, FrameType.TASK, true, true, false).m_138398_(parent).m_138386_("requirement", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()})).m_138389_(consumer, "fossil:fossil/" + key);
    }

    private Advancement tag(ItemLike item, TagKey<Item> tag, Advancement parent, Consumer<Advancement> consumer) {
        String key = tag.f_203868_().m_135815_();
        return this.tag(item, tag, parent, consumer, key);
    }

    private Component title(String key) {
        return Component.m_237115_((String)String.format("advancements.%s.%s.title", "fossil", key));
    }

    private Component description(String key) {
        return Component.m_237115_((String)String.format("advancements.%s.%s.description", "fossil", key));
    }

    private ResourceLocation key(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    private ResourceLocation key(EntityType<?> entityType) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entityType);
    }
}

