/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.event;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.capabilities.forge.ModCapabilitiesImpl;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.event.ModEvents;
import com.github.teamfossilsarcheology.fossil.forge.capabilities.mammal.MammalCapProvider;
import com.github.teamfossilsarcheology.fossil.forge.capabilities.player.FirstHatchCapProvider;
import com.github.teamfossilsarcheology.fossil.forge.tests.HopperTests;
import com.github.teamfossilsarcheology.fossil.forge.tests.MiscTests;
import com.github.teamfossilsarcheology.fossil.forge.tests.RecipeTests;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CMammalCapMessage;
import com.github.teamfossilsarcheology.fossil.util.Version;
import com.github.teamfossilsarcheology.fossil.villager.ModTrades;
import com.github.teamfossilsarcheology.fossil.villager.ModVillagers;
import com.github.teamfossilsarcheology.fossil.world.effect.ComfyBedEffect;
import com.github.teamfossilsarcheology.fossil.world.effect.ModEffects;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegisterGameTestsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fossil")
public class ForgeModEvents {
    @SubscribeEvent
    public static void registerTests(RegisterGameTestsEvent event) {
        if (Version.debugEnabled()) {
            event.register(HopperTests.class);
            event.register(MiscTests.class);
            event.register(RecipeTests.class);
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == ModVillagers.ARCHEOLOGIST.get()) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).addAll(ModTrades.getArcheoList(1));
            ((List)trades.get(2)).addAll(ModTrades.getArcheoList(2));
            ((List)trades.get(3)).addAll(ModTrades.getArcheoList(3));
            ((List)trades.get(4)).addAll(ModTrades.getArcheoList(4));
            ((List)trades.get(5)).addAll(ModTrades.getArcheoList(5));
        } else if (event.getType() == ModVillagers.PALEONTOLOGIST.get()) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).addAll(ModTrades.getPaleoList(1));
            ((List)trades.get(2)).addAll(ModTrades.getPaleoList(2));
            ((List)trades.get(3)).addAll(ModTrades.getPaleoList(3));
            ((List)trades.get(4)).addAll(ModTrades.getPaleoList(4));
            ((List)trades.get(5)).addAll(ModTrades.getPaleoList(5));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Animal) {
            Animal animal = (Animal)livingEntity;
            int currentProgress = ModCapabilities.getEmbryoProgress(animal);
            if (currentProgress == 0) {
                return;
            }
            if (currentProgress >= FossilConfig.getInt("pregnancyDuration")) {
                if (!animal.f_19853_.f_46443_) {
                    ModEvents.growEntity(ModCapabilities.getEmbryo(animal), (LivingEntity)animal);
                    ModCapabilities.stopPregnancy(animal);
                }
            } else {
                ModCapabilities.setEmbryoProgress(animal, currentProgress + 1);
            }
        }
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Animal animal;
        Object object = event.getObject();
        if (object instanceof Animal && PrehistoricEntityInfo.isMammal((Mob)(animal = (Animal)object))) {
            MammalCapProvider mammalProvider = new MammalCapProvider();
            event.addListener(mammalProvider::invalidate);
            event.addCapability(MammalCapProvider.IDENTIFIER, (ICapabilityProvider)mammalProvider);
        } else if (event.getObject() instanceof Player) {
            FirstHatchCapProvider playerProvider = new FirstHatchCapProvider();
            event.addListener(playerProvider::invalidate);
            event.addCapability(FirstHatchCapProvider.IDENTIFIER, (ICapabilityProvider)playerProvider);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        ModCapabilitiesImpl.getFirstHatchCap(event.getOriginal()).ifPresent(originalCap -> ModCapabilitiesImpl.getFirstHatchCap(event.getEntity()).ifPresent(newCap -> newCap.setHatchedDinosaur(originalCap.hasHatchedDinosaur())));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            ModCapabilitiesImpl.getMammalCap(animal).ifPresent(iMammalCap -> MessageHandler.CAP_CHANNEL.sendToPlayers(List.of(serverPlayer), (Object)new S2CMammalCapMessage(animal, iMammalCap.getEmbryoProgress(), iMammalCap.getEmbryo())));
        }
    }

    @SubscribeEvent
    public static void allowDaySleep(PlayerSleepInBedEvent event) {
        if (ComfyBedEffect.canApply(event.getOptionalPos(), event.getEntity().m_9236_())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void allowDaySleep(SleepingTimeCheckEvent event) {
        if (ComfyBedEffect.canApply(event.getSleepingLocation(), event.getEntity().m_9236_())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void addComfyBedEffect(PlayerWakeUpEvent event) {
        if (ComfyBedEffect.canApply(event.getEntity().m_21257_(), event.getEntity().m_9236_())) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModEffects.COMFY_BED.get(), 24000, 0));
        }
    }

    @SubscribeEvent
    public static void addComfyBedEffect(LivingEvent.LivingVisibilityEvent event) {
        if (event.getEntity().m_21023_((MobEffect)ModEffects.COMFY_BED.get())) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    public static void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            FossilMod.syncData(event.getPlayer());
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                FossilMod.syncData(player);
            }
        }
    }
}

