/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class MultiOutputAndSlotsRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    protected final Ingredient input;
    private final NavigableMap<Double, ItemStack> weightedOutputs;

    protected MultiOutputAndSlotsRecipe(ResourceLocation resourceLocation, Ingredient input, NavigableMap<Double, ItemStack> weightedOutputs) {
        this.id = resourceLocation;
        this.input = input;
        this.weightedOutputs = weightedOutputs;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.input);
        return nonNullList;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public NavigableMap<Double, ItemStack> getWeightedOutputs() {
        return this.weightedOutputs;
    }

    public boolean m_5818_(Container container, Level level) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!this.matches(container, i)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Container container, int slot) {
        ItemStack itemStack = container.m_8020_(slot);
        if (itemStack.m_41619_()) {
            return false;
        }
        return this.input.test(itemStack);
    }

    @NotNull
    public ItemStack m_5874_(Container container) {
        if (container instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)container;
            return this.weightedOutputs.higherEntry(blockEntity.m_58904_().f_46441_.m_188500_() * (Double)this.weightedOutputs.lastKey()).getValue().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer<T extends MultiOutputAndSlotsRecipe>
    implements RecipeSerializer<T> {
        protected final Constructor<T> constructor;

        protected Serializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        private static NavigableMap<Double, ItemStack> weightedItemsFromJson(JsonArray outputsArray) {
            TreeMap<Double, ItemStack> items = new TreeMap<Double, ItemStack>();
            double total = 0.0;
            for (int i = 0; i < outputsArray.size(); ++i) {
                JsonObject object = outputsArray.get(i).getAsJsonObject();
                ItemStack item = ShapedRecipe.m_151274_((JsonObject)object);
                if (item.m_41619_()) continue;
                items.put(total += GsonHelper.m_144784_((JsonObject)object, (String)"weight"), item);
            }
            return items;
        }

        @NotNull
        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
            Ingredient input = Ingredient.m_43917_((JsonElement)jsonelement);
            NavigableMap<Double, ItemStack> outputs = Serializer.weightedItemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"outputs"));
            return (T)((MultiOutputAndSlotsRecipe)this.constructor.construct(recipeId, input, outputs));
        }

        @NotNull
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            TreeMap<Double, ItemStack> outputs = new TreeMap<Double, ItemStack>();
            int outputSize = buffer.m_130242_();
            for (int i = 0; i < outputSize; ++i) {
                outputs.put(buffer.readDouble(), buffer.m_130267_());
            }
            return (T)((MultiOutputAndSlotsRecipe)this.constructor.construct(recipeId, input, outputs));
        }

        public void toNetwork(FriendlyByteBuf buffer, MultiOutputAndSlotsRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130130_(recipe.weightedOutputs.size());
            for (Map.Entry output : recipe.weightedOutputs.entrySet()) {
                buffer.writeDouble(((Double)output.getKey()).doubleValue());
                buffer.m_130055_((ItemStack)output.getValue());
            }
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(ResourceLocation var1, Ingredient var2, NavigableMap<Double, ItemStack> var3);
        }
    }
}

