/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.file.AnimationFileLoader;
import software.bernie.geckolib3.geo.raw.pojo.Converter;
import software.bernie.geckolib3.geo.raw.pojo.RawGeoModel;
import software.bernie.geckolib3.geo.raw.tree.RawGeometryTree;
import software.bernie.geckolib3.geo.render.GeoBuilder;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class SkeletonGeoModelLoader
extends ResourceLoader<Map<ResourceLocation, GeoModel>> {
    public static final SkeletonGeoModelLoader INSTANCE = new SkeletonGeoModelLoader();
    private Map<ResourceLocation, GeoModel> geoModels = ImmutableMap.of();

    public SkeletonGeoModelLoader() {
        super(PackType.CLIENT_RESOURCES, "geo/entity", ".json");
    }

    @NotNull
    protected Map<ResourceLocation, GeoModel> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ResourceLocation resourceLocation : this.listResources(resourceManager)) {
            try {
                RawGeoModel rawModel = Converter.fromJsonString((String)AnimationFileLoader.getResourceAsString((ResourceLocation)resourceLocation, (ResourceManager)resourceManager));
                RawGeometryTree rawGeometryTree = RawGeometryTree.parseHierarchy((RawGeoModel)rawModel);
                map.put(resourceLocation, GeoBuilder.getGeoBuilder((String)"fossil").constructGeoModel(rawGeometryTree));
            }
            catch (IOException e) {
                FossilMod.LOGGER.error(String.format("Error parsing %s", resourceLocation), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, GeoModel> files, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.putAll(files);
        this.geoModels = mapBuilder.build();
        FossilMod.LOGGER.info("Loaded {} skeleton models", (Object)this.geoModels.size());
    }

    public GeoModel getSkeletonModel(ResourceLocation file) {
        return this.geoModels.get(file);
    }
}

