/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.AbstractAnimationList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SForceAnimationMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SRotationMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;

public class AnimationTab<T extends Mob>
extends DebugTab<T> {
    private float rotYBase;
    private float rotXBase;

    protected AnimationTab(DebugScreen debugScreen, @NotNull T mob) {
        super(debugScreen, mob);
        this.rotYBase = ((Mob)mob).f_20883_;
        this.rotXBase = mob.m_146909_();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yLeft = 0;
        boolean yRight = false;
        DebugSlider sliderY = this.addWidget(new DebugSlider(20, 30 + yLeft++ * 30, width / 4, 20, (Component)Component.m_237113_((String)"Rotation Y: "), (Component)Component.m_237113_((String)""), 0.0, 360.0, 0.0, 5.0, 3, true){

            @Override
            protected void m_5697_() {
                float rotY = (float)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                float newRot = (AnimationTab.this.rotYBase + rotY) % 360.0f;
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SRotationMessage(((Mob)AnimationTab.this.entity).m_19879_(), newRot, 0));
                ((Mob)AnimationTab.this.entity).m_5618_(newRot);
                ((Mob)AnimationTab.this.entity).m_146922_(newRot);
                ((Mob)AnimationTab.this.entity).m_5616_(newRot);
            }
        });
        DebugSlider sliderX = this.addWidget(new DebugSlider(20, 30 + yLeft++ * 30, width / 4, 20, (Component)Component.m_237113_((String)"Rotation X: "), (Component)Component.m_237113_((String)""), 0.0, 360.0, 0.0, 5.0, 3, true){

            @Override
            protected void m_5697_() {
                float rotX = (float)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                float newRot = (AnimationTab.this.rotXBase + rotX) % 360.0f;
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SRotationMessage(((Mob)AnimationTab.this.entity).m_19879_(), newRot, 1));
                ((Mob)AnimationTab.this.entity).m_146926_(newRot);
            }
        });
        this.addWidget(new Button(20, 30 + yLeft++ * 30, width / 6, 20, (Component)Component.m_237113_((String)"Reset Rotation"), button -> {
            this.rotYBase = 0.0f;
            this.rotXBase = 0.0f;
            sliderY.setSliderValue(0.0, true);
            sliderX.setSliderValue(0.0, true);
        }, (button, poseStack, i, j) -> this.debugScreen.m_96602_(poseStack, (Component)Component.m_237113_((String)"client side only"), i, j)));
        Map controllers = ((IAnimatable)((Mob)this.entity)).getFactory().getOrCreateAnimationData(((Mob)this.entity).m_19879_()).getAnimationControllers();
        this.addWidget(new AnimationList(width - width / 4 + 20, ((PrehistoricAnimatable)((Mob)this.entity)).getAllAnimations(), controllers, this.minecraft, animationObject -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SForceAnimationMessage(animationObject.controller(), ((Mob)this.entity).m_19879_(), animationObject.name(), animationObject.speed(), animationObject.transitionLength(), animationObject.loop()))));
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
        AnimationTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Rotation: " + ((Mob)this.entity).m_146908_())), (int)20, (int)160, (int)0xFFFFFF);
        AnimationTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Rotation Body: " + ((Mob)this.entity).f_20883_)), (int)20, (int)180, (int)0xFFFFFF);
        AnimationTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Rotation Head: " + ((Mob)this.entity).m_6080_())), (int)20, (int)200, (int)0xFFFFFF);
    }

    private static class AnimationList
    extends AbstractAnimationList {
        private final Map<String, AbstractWidget> pauseButtons = new HashMap<String, AbstractWidget>();
        private final Map<String, DebugSlider> pauseSliders = new HashMap<String, DebugSlider>();

        public AnimationList(int x0, Map<String, ? extends AnimationInfo> animations, Map<String, AnimationController> controllers, Minecraft minecraft, Consumer<AbstractAnimationList.AnimationObject> function) {
            super(x0, 250, 21, 120, animations, minecraft, function);
            int buttonX = x0;
            int buttonY = this.f_93390_ - 110;
            if (controllers.isEmpty()) {
                return;
            }
            List controllerNames = controllers.keySet().stream().toList();
            this.currentControllerName = (String)controllerNames.get(0);
            this.addWidget(CycleButton.m_168894_(Component::m_237113_).m_232502_(controllerNames).m_168948_((Object)this.currentControllerName).m_168936_(buttonX, buttonY, 200, 20, (Component)Component.m_237113_((String)"Controller"), (button, controller) -> {
                this.removeWidget(this.pauseButtons.get(this.currentControllerName));
                this.removeWidget(this.pauseSliders.get(this.currentControllerName));
                this.addWidget(this.pauseButtons.get(controller));
                this.addWidget(this.pauseSliders.get(controller));
                this.currentControllerName = controller;
            }));
            this.addWidget(new DebugSlider(buttonX, buttonY + 21, 99, 20, (Component)Component.m_237113_((String)"Transition: "), (Component)Component.m_237113_((String)""), 0.0, 20.0, this.transitionLength, 1.0, 3, true){

                @Override
                protected void m_5697_() {
                    transitionLength = (float)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(new DebugSlider(buttonX + 102, buttonY + 21, 99, 20, (Component)Component.m_237113_((String)"Speed: "), (Component)Component.m_237113_((String)""), 0.0, 3.0, this.speed, 0.05, 3, true){

                @Override
                protected void m_5697_() {
                    speed = (float)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(OptionInstance.m_231528_((String)"Loop", (boolean)this.loop, newLoop -> {
                this.loop = newLoop;
            }).m_231507_(Minecraft.m_91087_().f_91066_, buttonX, buttonY + 42, 99));
            for (String controllerName : controllerNames) {
                AnimationController animationController = controllers.get(controllerName);
                if (!(animationController instanceof PausableAnimationController)) continue;
                PausableAnimationController pausableAnimationController = (PausableAnimationController)animationController;
                DebugSlider slider = AnimationList.createPauseSlider(pausableAnimationController, buttonX, buttonY);
                CycleButton button2 = CycleButton.m_168916_((boolean)pausableAnimationController.isPaused()).m_168936_(buttonX + 102, buttonY + 42, 99, 20, (Component)Component.m_237113_((String)"Pause"), (cycleButton, paused) -> {
                    pausableAnimationController.pause((boolean)paused);
                    slider.f_93624_ = paused;
                    if (pausableAnimationController.getCurrentAnimation() != null) {
                        slider.maxValue = pausableAnimationController.getCurrentAnimation().animationLength;
                    }
                    if (Boolean.TRUE.equals(paused)) {
                        slider.setSliderValue(pausableAnimationController.getCurrentTick() / slider.maxValue, true);
                    }
                });
                this.pauseSliders.put(controllerName, slider);
                this.pauseButtons.put(controllerName, (AbstractWidget)button2);
                if (!controllerName.equals(this.currentControllerName)) continue;
                this.addWidget(button2);
                this.addWidget(slider);
            }
        }

        @NotNull
        private static DebugSlider createPauseSlider(final PausableAnimationController<?> pausableAnimationController, int buttonX, int buttonY) {
            double tick;
            double maxTick = tick = pausableAnimationController.getCurrentTick();
            if (pausableAnimationController.getCurrentAnimation() != null) {
                maxTick = pausableAnimationController.getCurrentAnimation().animationLength - 1.0;
            }
            var slider = new DebugSlider(buttonX, buttonY + 63, 200, 20, (Component)Component.m_237113_((String)"Time: "), (Component)Component.m_237113_((String)""), 0.0, maxTick, tick, 1.0, 3, true){

                @Override
                protected void m_5697_() {
                    pausableAnimationController.overrideTick(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            };
            slider.f_93624_ = pausableAnimationController.isPaused();
            return slider;
        }

        @Override
        protected int getEntryLeftPos() {
            return super.getEntryLeftPos() + this.f_93388_ / 2;
        }

        @Override
        protected int m_5756_() {
            return super.m_5756_() + this.f_93388_ / 2 - 4;
        }
    }
}

