/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.ToyTetheredLog;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.WoodType;

public class ToyTetheredLogModel
extends EntityModel<ToyTetheredLog> {
    public static final Map<String, ResourceLocation> TEXTURES = WoodType.m_61843_().filter(ToyBase::isVanillaWood).collect(Collectors.toMap(WoodType::m_61846_, woodType -> FossilMod.location("textures/entity/toy/log_swing_" + woodType.m_61846_() + ".png")));
    private final ModelPart model = ToyTetheredLogModel.createBodyLayer().m_171564_();
    private final ModelPart rope1 = this.model.m_171324_("rope1");

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition rope1 = root.m_171599_("rope1", CubeListBuilder.m_171558_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition rope2 = rope1.m_171599_("rope2", CubeListBuilder.m_171558_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition rope3 = rope2.m_171599_("rope3", CubeListBuilder.m_171558_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        rope3.m_171599_("log", CubeListBuilder.m_171558_().m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 16.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(ToyTetheredLog entity, float partialTick, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rot = 0.0f;
        if (entity.animationPlaying) {
            float tick = (float)entity.animationTick + partialTick;
            rot = (float)(0.5 * (double)Mth.m_14031_((float)(tick * 0.5f)) / Math.exp(tick / 10.0f));
        }
        this.rope1.f_104203_ = rot * entity.animationX;
        this.rope1.f_104205_ = rot * entity.animationZ;
    }

    public void m_7695_(PoseStack stack, VertexConsumer buffer, int packedLight, int packedOverlay, float r, float g, float b, float alpha) {
        this.model.m_104306_(stack, buffer, packedLight, packedOverlay, r, g, b, alpha);
    }
}

