/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.model.DinosaurEggModel;
import com.github.teamfossilsarcheology.fossil.client.renderer.RendererFabricFix;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DinosaurEggRenderer
extends LivingEntityRenderer<DinosaurEgg, DinosaurEggModel>
implements RendererFabricFix {
    private static final Map<String, ResourceLocation> TEXTURES = new Object2ObjectOpenHashMap();
    private static final ResourceLocation GOLDEN_EGG = FossilMod.location("textures/entity/egg/golden.png");

    public DinosaurEggRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DinosaurEggModel(), 0.25f);
    }

    protected void scale(DinosaurEgg egg, PoseStack poseStack, float partialTickTime) {
        float scale = EntityDataLoader.INSTANCE.getData(egg.getPrehistoricEntityInfo().resourceName).eggScale();
        if (egg.getScaleOverride() > 0.0f) {
            scale = egg.getScaleOverride();
        }
        this.f_114477_ = 0.25f * scale;
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)egg, poseStack, partialTickTime);
    }

    @Nullable
    protected RenderType getRenderType(DinosaurEgg egg, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (bodyVisible) {
            if (egg.isGoldenEgg()) {
                return ((DinosaurEggModel)this.f_115290_).m_103119_(GOLDEN_EGG);
            }
            ResourceLocation resourceLocation = this.getTextureLocation(egg);
            return ((DinosaurEggModel)this.f_115290_).m_103119_(resourceLocation);
        }
        return null;
    }

    protected boolean shouldShowName(DinosaurEgg entity) {
        return false;
    }

    @Override
    public ResourceLocation _getTextureLocation(Entity entity) {
        return this.getTextureLocation((DinosaurEgg)entity);
    }

    @NotNull
    public ResourceLocation getTextureLocation(DinosaurEgg entity) {
        return TEXTURES.computeIfAbsent(entity.getPrehistoricEntityInfo().resourceName, name -> {
            ResourceLocation rl = FossilMod.location("textures/entity/egg/egg_" + name + ".png");
            Minecraft.m_91087_().m_91097_().m_118506_(rl);
            AbstractTexture tex = Minecraft.m_91087_().m_91097_().m_118506_(rl);
            if (tex == MissingTextureAtlasSprite.m_118080_()) {
                return FossilMod.location("textures/entity/egg/fallback.png");
            }
            return rl;
        });
    }
}

