/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DinoLeapAtTargetGoal
extends DelayedAttackGoal<PrehistoricLeaping> {
    private static final int ATTACK = 0;
    private static final int LEAP = 1;
    private int attackType = -1;
    private int lastAttackType = -1;

    public DinoLeapAtTargetGoal(PrehistoricLeaping dino) {
        super(dino, dino.attributes().sprintMod(), false);
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean m_8036_() {
        if (!((PrehistoricLeaping)this.mob).m_20096_()) {
            return false;
        }
        return super.m_8036_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.attackType = -1;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        ((PrehistoricLeaping)this.mob).getLeapSystem().setAttackRiding(false);
        ((PrehistoricLeaping)this.mob).m_8127_();
    }

    @Override
    protected boolean canUpdateMovement() {
        return this.attackType == 0 || this.attackType == -1;
    }

    @Override
    protected void checkAndPerformAttack(LivingEntity enemy, boolean inRange) {
        long currentTime = ((PrehistoricLeaping)this.mob).f_19853_.m_46467_();
        if (this.attackType == 0) {
            if (inRange && this.attackDamageTick > 0L && currentTime >= this.attackDamageTick) {
                ((PrehistoricLeaping)this.mob).attackTarget(enemy);
                this.attackDamageTick = -1L;
                this.attackType = -1;
            } else if (currentTime >= this.attackDamageTick + 20L) {
                this.attackType = -1;
            }
        } else if (currentTime > this.attackEndTick + 20L) {
            int attack = -1;
            if (inRange) {
                attack = ((PrehistoricLeaping)this.mob).m_217043_().m_188503_(5) > 0 ? 0 : 1;
            } else if ((this.lastAttackType != 1 || currentTime > ((PrehistoricLeaping)this.mob).getLeapSystem().getLastLeapEndTick() + 60L) && !enemy.m_20160_() && ((PrehistoricLeaping)this.mob).m_20280_((Entity)enemy) < 30.0) {
                attack = 1;
            }
            if (attack == 0) {
                this.lastAttackType = this.attackType = 0;
                ServerAnimationInfo animation = ((PrehistoricLeaping)this.mob).startAttack();
                this.attackEndTick = (long)((double)currentTime + animation.animation.animationLength);
                this.attackDamageTick = Math.min((long)((double)currentTime + animation.actionDelay), this.attackEndTick);
            } else if (attack == 1) {
                this.lastAttackType = this.attackType = 1;
                ((PrehistoricLeaping)this.mob).getLeapSystem().setLeapTarget(enemy);
                ((PrehistoricLeaping)this.mob).getLeapSystem().setLastLeapEndTick(currentTime);
            }
        }
    }

    public void doLeapMovement() {
        ((PrehistoricLeaping)this.mob).m_21391_((Entity)((PrehistoricLeaping)this.mob).m_5448_(), 100.0f, 100.0f);
        Vec3 offset = Util.directionVecTo((Entity)this.mob, (Entity)((PrehistoricLeaping)this.mob).m_5448_()).m_82520_(0.0, (double)((PrehistoricLeaping)this.mob).m_5448_().m_20206_(), 0.0);
        ((PrehistoricLeaping)this.mob).m_20256_(offset.m_82541_());
    }
}

