/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.block.entity.FeederBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.ai.MoveToFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EatFromFeederGoal
extends MoveToFoodGoal {
    private final int chunkRadius;

    public EatFromFeederGoal(Prehistoric entity) {
        super(entity, 0.75, 32);
        this.chunkRadius = 2;
    }

    public EatFromFeederGoal(Prehistoric entity, int chunkRadius) {
        super(entity, 0.75, 32);
        this.chunkRadius = chunkRadius;
    }

    @Override
    public void m_8037_() {
        BlockEntity blockEntity;
        super.m_8037_();
        if (this.isReachedTarget() && (blockEntity = this.entity.f_19853_.m_7702_(this.targetPos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feeder = (FeederBlockEntity)blockEntity;
            if (Math.abs(this.entity.f_20924_) <= 0.08f) {
                ++this.feedingTicks;
                if (this.entity.getHunger() < this.entity.getMaxHunger()) {
                    feeder.feedDinosaur(this.entity);
                }
                this.entity.m_5634_(0.1f);
                if (this.entity.f_19853_.m_46467_() > this.animEndTick) {
                    AnimationInfo animationInfo = this.entity.nextEatingAnimation();
                    this.entity.getAnimationLogic().triggerAnimation("Movement/Idle", animationInfo, AnimationCategory.EAT);
                    this.animEndTick = (long)((double)this.entity.f_19853_.m_46467_() + animationInfo.animation.animationLength);
                }
            }
        }
    }

    @Override
    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        return this.isValidTarget(pos, level.m_7702_(pos));
    }

    protected boolean isValidTarget(BlockPos pos, BlockEntity blockEntity) {
        FeederBlockEntity feeder;
        if (this.avoidCache.contains(pos.m_121878_())) {
            return false;
        }
        if (!(blockEntity instanceof FeederBlockEntity) || (feeder = (FeederBlockEntity)blockEntity).isEmpty(this.entity.data().diet())) {
            return false;
        }
        return Util.canSeeFood(this.entity, pos) || (double)this.entity.getHunger() < (double)this.entity.getMaxHunger() * 0.5;
    }

    @Override
    protected boolean findNearestBlock() {
        BlockPos mobPos = this.entity.m_20183_();
        Optional<BlockPos> target = ChunkPos.m_45596_((ChunkPos)new ChunkPos(mobPos), (int)this.chunkRadius).flatMap(chunkPos -> this.entity.f_19853_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_62954_().entrySet().stream()).filter(entry -> this.isValidTarget((BlockPos)entry.getKey(), (BlockEntity)entry.getValue())).map(Map.Entry::getKey).min(Comparator.comparingInt(pos -> pos.m_123333_((Vec3i)mobPos)));
        if (target.isPresent()) {
            this.setTargetPos(target.get());
            return true;
        }
        this.clearTicks = !this.avoidCache.isEmpty() ? 400 : 0;
        return false;
    }
}

