/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class EnterWaterGoal<T extends Prehistoric>
extends Goal {
    protected final T dino;
    private final int searchRange;
    private final float speedModifier;
    private BlockPos shelterPos;

    public EnterWaterGoal(T dino, float speedModifier) {
        this(dino, 20, speedModifier);
    }

    public EnterWaterGoal(T dino, int searchRange, float speedModifier) {
        this.dino = dino;
        this.searchRange = searchRange;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.dino.m_20069_() || !((SwimmingAnimal)this.dino).isAmphibious()) {
            return false;
        }
        if (((SwimmingAnimal)this.dino).timeInWater() != 0 || ((SwimmingAnimal)this.dino).timeOnLand() <= 1000) {
            return false;
        }
        return this.findPossibleShelter();
    }

    public boolean m_8045_() {
        return !this.dino.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.dino.m_21573_().m_26519_((double)this.shelterPos.m_123341_(), (double)this.shelterPos.m_123342_(), (double)this.shelterPos.m_123343_(), (double)this.speedModifier);
    }

    private boolean findPossibleShelter() {
        RandomSource random = this.dino.m_217043_();
        Level level = ((Prehistoric)this.dino).f_19853_;
        BlockPos original = this.dino.m_20183_();
        BlockPos.MutableBlockPos mutable = original.m_122032_();
        for (int i = 0; i < 10; ++i) {
            mutable.m_122184_(random.m_188503_(this.searchRange) - 10, random.m_188503_(6) - 3, random.m_188503_(this.searchRange) - 10);
            if (!level.m_6425_((BlockPos)mutable).m_205070_(FluidTags.f_13131_)) continue;
            this.shelterPos = mutable.m_7949_();
            return true;
        }
        return false;
    }
}

