/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GrabMeleeAttackGoal
extends DelayedAttackGoal<PrehistoricSwimming> {
    private static final int ATTACK = 0;
    private static final int GRAB = 1;
    private static final int GRAB_DURATION = 55;
    private LivingEntity attackTarget;
    private int attackType = -1;
    private long grabStartTick = -1L;

    public GrabMeleeAttackGoal(PrehistoricSwimming entity, double speed, boolean followTargetEvenIfNotSeen) {
        super(entity, speed, followTargetEvenIfNotSeen);
    }

    @Override
    public boolean m_8045_() {
        if (this.attackType == 0) {
            return super.m_8045_();
        }
        if (this.attackTarget == null || this.attackTarget.m_213877_() || ((PrehistoricSwimming)this.mob).getCurrentOrder() == OrderType.STAY) {
            return false;
        }
        if (!(this.attackType != 1 || ((PrehistoricSwimming)this.mob).isDoingGrabAttack() && ((PrehistoricSwimming)this.mob).m_20363_((Entity)this.attackTarget))) {
            this.attackEndTick = ((PrehistoricSwimming)this.mob).f_19853_.m_46467_() + 20L;
            return false;
        }
        return CAN_ATTACK_TARGET.test(this.attackTarget);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.attackTarget = ((PrehistoricSwimming)this.mob).m_5448_();
        this.attackType = -1;
        this.grabStartTick = -1L;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        ((PrehistoricSwimming)this.mob).setDoingGrabAttack(false);
    }

    @Override
    protected boolean canUpdateMovement() {
        return this.attackType != 1;
    }

    @Override
    protected void checkAndPerformAttack(LivingEntity enemy, boolean inRange) {
        long currentTime = ((PrehistoricSwimming)this.mob).f_19853_.m_46467_();
        if (this.attackType == 1) {
            for (Entity passenger : ((PrehistoricSwimming)this.mob).m_20197_()) {
                boolean hurt;
                if (!(passenger instanceof LivingEntity) || passenger == ((PrehistoricSwimming)this.mob).getRidingPlayer() || ((PrehistoricSwimming)this.mob).f_19797_ % 20 != 0 || (hurt = passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)((PrehistoricSwimming)this.mob).m_21133_(Attributes.f_22281_))) && (currentTime < this.grabStartTick + 55L || ((PrehistoricSwimming)this.mob).m_217043_().m_188503_(5) != 0)) continue;
                this.attackEndTick = currentTime + 20L;
                ((PrehistoricSwimming)this.mob).stopGrabAttack(passenger);
            }
        } else if (this.attackType == 0) {
            if (inRange && this.attackDamageTick > 0L && currentTime >= this.attackDamageTick) {
                ((PrehistoricSwimming)this.mob).attackTarget(enemy);
                ((PrehistoricSwimming)this.mob).destroyBoat((Entity)enemy);
                this.attackDamageTick = -1L;
                this.attackType = -1;
            }
        } else if (currentTime > this.attackEndTick + 20L && inRange) {
            boolean tooBig = Util.isEntityLargerThan((Entity)enemy, ((PrehistoricSwimming)this.mob).grabTargetSize());
            if (tooBig || ((PrehistoricSwimming)this.mob).m_217043_().m_188503_(5) > 0 || ((PrehistoricSwimming)this.mob).m_20202_() == enemy) {
                this.attackType = 0;
                ServerAnimationInfo animationInfo = ((PrehistoricSwimming)this.mob).startAttack();
                this.attackEndTick = (long)((double)currentTime + animationInfo.animation.animationLength);
                this.attackDamageTick = Math.min((long)((double)currentTime + animationInfo.actionDelay), this.attackEndTick);
            } else {
                this.attackType = 1;
                ((PrehistoricSwimming)this.mob).destroyBoat((Entity)enemy);
                ((PrehistoricSwimming)this.mob).startGrabAttack((Entity)enemy);
                this.attackEndTick = 1L;
                this.grabStartTick = currentTime;
            }
        }
    }
}

