/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.monster;

import com.github.teamfossilsarcheology.fossil.block.entity.AnuBarrierBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.AnuDead;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhaseSystem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.sounds.MusicHandler;
import com.github.teamfossilsarcheology.fossil.world.dimension.ModDimensions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnuBoss
extends PathfinderMob
implements RangedAttackMob {
    public static final int ARENA_RADIUS = 25;
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.m_135353_(AnuBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> WEAK = SynchedEntityData.m_135353_(AnuBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Component SPAWN_1 = Component.m_237115_((String)"entity.fossil.anu.hello");
    private static final Component SPAWN_2 = Component.m_237115_((String)"entity.fossil.anu.fewBeaten");
    private static final Component ANU_COMBAT_SWORD = Component.m_237115_((String)"entity.fossil.anu.draw");
    private static final Component ANU_COMBAT_BOW = Component.m_237115_((String)"entity.fossil.anu.coward");
    private static final Component ANU_COMBAT_FIST = Component.m_237115_((String)"entity.fossil.anu.fist");
    private static final Component ANU_COMBAT_ANCIENT = Component.m_237115_((String)"entity.fossil.anu.ancient");
    private static final Component ANU_DEATH = Component.m_237115_((String)"entity.fossil.anu.death");
    private static final int SONG_LENGTH = 4041;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private Vec3 spawnPosition = Vec3.f_82478_;
    public final AnuPhaseSystem phaseSystem = new AnuPhaseSystem(this);
    private int songTick;

    public AnuBoss(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new AnuMoveControl(this);
        this.f_21364_ = 50;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 4.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 4.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AnuBoss.m_21552_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22279_, 0.35).m_22266_(Attributes.f_22281_);
    }

    public static Component getRandomGreeting(RandomSource random) {
        return random.m_188503_(2) == 0 ? SPAWN_1 : SPAWN_2;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PHASE, (Object)AnuPhase.MELEE.ordinal());
        this.f_19804_.m_135372_(WEAK, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (DATA_PHASE.equals(key) && this.f_19853_.f_46443_) {
            this.phaseSystem.setPhase(AnuPhase.values()[(Integer)this.f_19804_.m_135370_(DATA_PHASE)]);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6072_() {
        return false;
    }

    public Vec3 getSpawnPos() {
        return this.spawnPosition;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_19853_.f_46443_) {
            if (this.songTick < 4041) {
                ++this.songTick;
            }
            if (this.songTick == 4040) {
                this.songTick = 0;
            }
            if (this.songTick == 1) {
                MusicHandler.startMusic((SoundEvent)ModSounds.MUSIC_ANU.get());
            }
            if (!this.m_6084_()) {
                MusicHandler.stopMusic((SoundEvent)ModSounds.MUSIC_ANU.get());
            }
            if (this.f_20888_ != null && !this.f_20888_.m_6084_()) {
                MusicHandler.stopMusic((SoundEvent)ModSounds.MUSIC_ANU.get());
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            this.phaseSystem.getCurrentPhase().doClientTick();
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.phaseSystem.getCurrentPhase().doServerTick();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean isWeak() {
        return (Boolean)this.f_19804_.m_135370_(WEAK);
    }

    public void setWeak(boolean weak) {
        this.f_19804_.m_135381_(WEAK, (Object)weak);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity trueSource = source.m_7639_();
        if (source == DamageSource.f_19310_ || source.m_19372_() && trueSource == null) {
            return false;
        }
        this.phaseSystem.getCurrentPhase().onHurt(source, amount);
        if (source.m_7640_() instanceof LargeFireball && source.m_7639_() instanceof Player) {
            super.m_6469_(source, 20.0f);
            return true;
        }
        if (source == DamageSource.f_19317_ && this.m_20186_() < (double)this.f_19853_.m_141937_()) {
            this.m_20219_(this.spawnPosition);
            return false;
        }
        if (this.f_19853_.f_46443_ && trueSource instanceof Player) {
            Player player = (Player)trueSource;
            if (this.f_19796_.m_188503_(10) == 0) {
                ItemStack itemStack = player.m_150109_().m_36056_();
                if (itemStack.m_150930_((Item)ModItems.ANCIENT_SWORD.get())) {
                    player.m_5661_(ANU_COMBAT_ANCIENT, false);
                } else if (itemStack.m_41720_() instanceof SwordItem) {
                    player.m_5661_(ANU_COMBAT_SWORD, false);
                } else if (source.m_19360_()) {
                    player.m_5661_(ANU_COMBAT_BOW, false);
                } else if (itemStack.m_41619_()) {
                    player.m_5661_(ANU_COMBAT_FIST, false);
                }
            }
        }
        return super.m_6469_(source, this.isWeak() ? amount * 1.25f : amount);
    }

    private void removeBarriers() {
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46472_() == ModDimensions.ANU_LAIR) {
            AnuLair anuLair = (AnuLair)((ServerLevel)this.f_19853_).m_8895_().m_164858_(AnuLair::load, "anu_lair");
            if (anuLair != null) {
                for (BlockPos barrierPosition : anuLair.barrierPositions) {
                    BlockEntity blockEntity = this.f_19853_.m_7702_(barrierPosition);
                    if (!(blockEntity instanceof AnuBarrierBlockEntity)) continue;
                    AnuBarrierBlockEntity blockEntity2 = (AnuBarrierBlockEntity)blockEntity;
                    blockEntity2.disable();
                }
            }
            ((ServerLevel)this.f_19853_).m_8895_().m_164855_("anu_lair", (SavedData)AnuLair.killed());
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.removeBarriers();
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.f_19853_.f_46443_) {
            AnuDead anuDead = (AnuDead)((EntityType)ModEntities.ANU_DEAD.get()).m_20615_(this.f_19853_);
            anuDead.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.f_19853_.m_7967_((Entity)anuDead);
            this.removeBarriers();
        } else {
            MusicHandler.stopMusic((SoundEvent)ModSounds.MUSIC_ANU.get());
            List players = this.f_19853_.m_45955_(TargetingConditions.m_148352_(), (LivingEntity)this, this.m_20191_().m_82377_(30.0, 15.0, 30.0));
            for (Player player : players) {
                player.m_5661_(ANU_DEATH, false);
            }
        }
        super.m_6667_(damageSource);
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean hitByPlayer) {
        super.m_7472_(damageSource, looting, hitByPlayer);
        ItemEntity itemEntity = this.m_19998_((ItemLike)ModItems.ANCIENT_KEY.get());
        if (itemEntity != null) {
            itemEntity.m_32064_();
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_7327_(Entity target) {
        if (this.f_19796_.m_188503_(4) == 0) {
            LightningBolt lightningBolt = (LightningBolt)((EntityType)ModEntities.ANCIENT_LIGHTNING_BOLT.get()).m_20615_(this.f_19853_);
            lightningBolt.m_20219_(target.m_20182_());
            this.f_19853_.m_7967_((Entity)lightningBolt);
        }
        return super.m_7327_(target);
    }

    public void m_6504_(LivingEntity target, float velocity) {
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20191_().f_82289_ - (this.m_20186_() + (double)(this.m_20206_() / 2.0f));
        double z = target.m_20189_() - this.m_20189_();
        this.m_5496_(SoundEvents.f_11923_, 1.0f, 1.0f);
        LargeFireball largeFireball = new LargeFireball(this.f_19853_, (LivingEntity)this, x, y, z, 2);
        largeFireball.m_6034_(this.m_20185_() + x * 0.1, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + 0.5, this.m_20189_() + z * 0.1);
        this.f_19853_.m_7967_((Entity)largeFireball);
    }

    public void m_6043_() {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.phaseSystem.getCurrentPhase().getAmbientSound();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12018_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.m_213945_(level.m_213780_(), difficulty);
        this.spawnPosition = this.m_20182_();
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.ANCIENT_SWORD.get()));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("SpawnPosX", this.spawnPosition.f_82479_);
        compound.m_128347_("SpawnPosY", this.spawnPosition.f_82480_);
        compound.m_128347_("SpawnPosZ", this.spawnPosition.f_82481_);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.spawnPosition = new Vec3(compound.m_128459_("SpawnPosX"), compound.m_128459_("SpawnPosY"), compound.m_128459_("SpawnPosZ"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public static class AnuLair
    extends SavedData {
        private boolean anuKilled;
        private final Set<BlockPos> barrierPositions = new HashSet<BlockPos>();

        public static AnuLair killed() {
            AnuLair anuLair = new AnuLair();
            anuLair.anuKilled = true;
            anuLair.m_77762_();
            return anuLair;
        }

        public static AnuLair spawned(Set<BlockPos> barriers) {
            AnuLair anuLair = new AnuLair();
            anuLair.barrierPositions.addAll(barriers);
            anuLair.m_77762_();
            return anuLair;
        }

        public static AnuLair load(CompoundTag compoundTag) {
            AnuLair anuLair = new AnuLair();
            anuLair.anuKilled = compoundTag.m_128471_("AnuKilled");
            ListTag barriers = compoundTag.m_128437_("Barriers", 10);
            anuLair.barrierPositions.clear();
            for (int i = 0; i < barriers.size(); ++i) {
                CompoundTag tag = barriers.m_128728_(i);
                anuLair.barrierPositions.add(new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z")));
            }
            return anuLair;
        }

        @NotNull
        public CompoundTag m_7176_(CompoundTag compoundTag) {
            compoundTag.m_128379_("AnuKilled", this.anuKilled);
            ListTag barriers = new ListTag();
            for (BlockPos blockPos : this.barrierPositions) {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("X", blockPos.m_123341_());
                tag.m_128405_("Y", blockPos.m_123342_());
                tag.m_128405_("Z", blockPos.m_123343_());
                barriers.add((Object)tag);
            }
            compoundTag.m_128365_("Barriers", (Tag)barriers);
            return compoundTag;
        }

        public boolean isAnuKilled() {
            return this.anuKilled;
        }
    }
}

