/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class ConfigCondition
extends VariantCondition {
    private final String configKey;

    private ConfigCondition(String configKey) {
        super(1.0);
        this.configKey = configKey;
    }

    public boolean test() {
        return FossilConfig.isEnabled(this.configKey);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConfigCondition that = (ConfigCondition)object;
        return Objects.equals(this.configKey, that.configKey);
    }

    public int hashCode() {
        return Objects.hashCode(this.configKey);
    }

    public static class Serializer
    implements VariantCondition.Serializer<ConfigCondition> {
        public ConfigCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new ConfigCondition(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"configKey"));
        }

        @Override
        public void save(CompoundTag tag, ConfigCondition condition) {
            tag.m_128359_("ConfigKey", condition.configKey);
        }

        @Override
        public ConfigCondition load(CompoundTag tag) {
            return new ConfigCondition(tag.m_128461_("ConfigKey"));
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ConfigCondition condition) {
            buf.m_130070_(condition.configKey);
        }

        @Override
        public ConfigCondition fromNetwork(FriendlyByteBuf buf) {
            return new ConfigCondition(buf.m_130277_());
        }
    }
}

