/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.client.model;

import com.github.teamfossilsarcheology.fossil.client.model.block.PlantBlockModel;
import com.github.teamfossilsarcheology.fossil.client.model.block.PlantModelBakery;
import com.github.teamfossilsarcheology.fossil.forge.client.model.PlantBakedModel;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class PlantModelGeometry
implements IUnbakedGeometry<PlantModelGeometry> {
    private final PlantBlockModel model;

    public PlantModelGeometry(PlantBlockModel model) {
        this.model = model;
    }

    public BakedModel bake(IGeometryBakingContext iModelConfiguration, ModelBakery arg, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides arg3, ResourceLocation location) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (PlantBlockModel.PlantBlockElement element : this.model.elements()) {
            for (Direction direction : element.faces().keySet()) {
                PlantBlockModel.PlantBlockElementFace face = element.faces().get(direction);
                TextureAtlasSprite texture = spriteGetter.apply(this.model.materials().get(face.texture().substring(1)));
                list.add(PlantModelBakery.bakeFace(element, face, texture, direction, modelState));
            }
        }
        return new PlantBakedModel(list, this.model.materials());
    }

    public Collection<Material> getMaterials(IGeometryBakingContext config, Function<ResourceLocation, UnbakedModel> function, Set<Pair<String, String>> set) {
        HashSet textures = Sets.newHashSet();
        for (PlantBlockModel.PlantBlockElement element : this.model.elements()) {
            for (PlantBlockModel.PlantBlockElementFace face : element.faces().values()) {
                Material texture = config.getMaterial(face.texture());
                textures.add(texture);
            }
        }
        return textures;
    }
}

