/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.providers;

import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ToyBallItem;
import com.github.teamfossilsarcheology.fossil.item.ToyScratchingPostItem;
import com.github.teamfossilsarcheology.fossil.item.ToyTetheredLogItem;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemProvider
extends ItemModelProvider {
    public ModItemProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "fossil", existingFileHelper);
    }

    protected void registerModels() {
        boolean dinoItems = true;
        boolean plantItems = true;
        boolean toyItems = true;
        if (toyItems) {
            Item item;
            for (RegistrySupplier registrySupplier : ModItems.TOY_BALLS.values()) {
                item = (ToyBallItem)((Object)registrySupplier.get());
                ResourceLocation resourceLocation = new ResourceLocation(this.key(item).m_135827_(), "item/" + this.key(item).m_135815_());
                this.builder(resourceLocation, this.key(item));
            }
            for (RegistrySupplier registrySupplier : ModItems.TOY_SCRATCHING_POSTS.values()) {
                item = (ToyScratchingPostItem)((Object)registrySupplier.get());
                ResourceLocation resourceLocation = new ResourceLocation(this.key(item).m_135827_(), "item/" + this.key(item).m_135815_());
                this.builder(resourceLocation, this.key(item));
            }
            for (RegistrySupplier registrySupplier : ModItems.TOY_TETHERED_LOGS.values()) {
                item = (ToyTetheredLogItem)((Object)registrySupplier.get());
                ResourceLocation resourceLocation = new ResourceLocation(this.key(item).m_135827_(), "item/" + this.key(item).m_135815_());
                this.builder(resourceLocation, this.key(item));
            }
        }
        if (dinoItems) {
            for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
                if (prehistoricEntityInfo.dnaItem != null) {
                    this.dnaItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.dnaItem)));
                }
                if (prehistoricEntityInfo.foodItem != null) {
                    this.foodItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.foodItem)), prehistoricEntityInfo, "meat");
                }
                if (prehistoricEntityInfo.cookedFoodItem != null) {
                    this.foodItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.cookedFoodItem)), prehistoricEntityInfo, "cooked");
                }
                if (prehistoricEntityInfo.eggItem != null) {
                    this.eggItem(this.key(prehistoricEntityInfo.eggItem));
                }
                if (prehistoricEntityInfo.birdEggItem != null) {
                    this.eggItem(this.key(prehistoricEntityInfo.birdEggItem));
                }
                if (prehistoricEntityInfo.cultivatedBirdEggItem != null) {
                    this.eggItem(this.key(prehistoricEntityInfo.cultivatedBirdEggItem));
                }
                if (prehistoricEntityInfo.embryoItem != null) {
                    this.embyroItem(this.key(prehistoricEntityInfo.embryoItem));
                }
                if (prehistoricEntityInfo.spawnEggItem != null) {
                    this.spawnEggItem(prehistoricEntityInfo.spawnEggItem);
                }
                if (prehistoricEntityInfo.armBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.armBoneItem)), prehistoricEntityInfo, "arm_bone");
                }
                if (prehistoricEntityInfo.footBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.footBoneItem)), prehistoricEntityInfo, "foot");
                }
                if (prehistoricEntityInfo.legBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.legBoneItem)), prehistoricEntityInfo, "leg_bone");
                }
                if (prehistoricEntityInfo.ribcageBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.ribcageBoneItem)), prehistoricEntityInfo, "ribcage");
                }
                if (prehistoricEntityInfo.skullBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.skullBoneItem)), prehistoricEntityInfo, "skull");
                }
                if (prehistoricEntityInfo.tailBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.tailBoneItem)), prehistoricEntityInfo, "tail");
                }
                if (prehistoricEntityInfo.uniqueBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.uniqueBoneItem)), prehistoricEntityInfo, "unique");
                }
                if (prehistoricEntityInfo.vertebraeBoneItem != null) {
                    this.boneItem(Objects.requireNonNull(this.key(prehistoricEntityInfo.vertebraeBoneItem)), prehistoricEntityInfo, "vertebrae");
                }
                if (prehistoricEntityInfo.bucketItem == null) continue;
                this.basicItem(this.key(prehistoricEntityInfo.bucketItem));
            }
            for (VanillaEntityInfo vanillaEntityInfo : VanillaEntityInfo.values()) {
                if (vanillaEntityInfo.dnaItem != null) {
                    this.dnaItem(Objects.requireNonNull(this.key(vanillaEntityInfo.dnaItem)));
                }
                if (vanillaEntityInfo.eggItem != null) {
                    this.eggItem(this.key(vanillaEntityInfo.eggItem));
                }
                if (vanillaEntityInfo.cultivatedBirdEggItem != null) {
                    this.eggItem(this.key(vanillaEntityInfo.cultivatedBirdEggItem));
                }
                if (vanillaEntityInfo.embryoItem == null) continue;
                this.embyroItem(this.key(vanillaEntityInfo.embryoItem));
            }
            this.spawnEggItem((Item)ModItems.ANU_BOSS_SPAWN_EGG.get());
            this.spawnEggItem((Item)ModItems.FAILURESAURUS_SPAWN_EGG.get());
            this.spawnEggItem((Item)ModItems.SENTRY_PIGLIN_SPAWN_EGG.get());
            this.spawnEggItem((Item)ModItems.TAR_SLIME_SPAWN_EGG.get());
            this.basicItem((Item)ModItems.ELASMOTHERIUM_FUR.get());
            this.basicItem((Item)ModItems.MAMMOTH_FUR.get());
            this.basicItem((Item)ModItems.THERIZINOSAURUS_DOWN.get());
            this.basicItem((Item)ModItems.MAGIC_CONCH.get());
            this.eggItem(this.key((Item)ModItems.ARTIFICIAL_HONEYCOMB.get()));
        }
        if (plantItems) {
            for (PrehistoricPlantInfo prehistoricPlantInfo : PrehistoricPlantInfo.values()) {
                if (prehistoricPlantInfo.berryItem() == null) continue;
                ResourceLocation resourceLocation = new ResourceLocation(this.key((Item)prehistoricPlantInfo.berryItem().get()).m_135827_(), "item/" + this.key((Item)prehistoricPlantInfo.berryItem().get()).m_135815_());
                this.builder(resourceLocation, this.key((Item)prehistoricPlantInfo.berryItem().get()));
            }
            for (PrehistoricPlantInfo prehistoricPlantInfo : PrehistoricPlantInfo.plantsWithSeeds()) {
                if (prehistoricPlantInfo == PrehistoricPlantInfo.MUTANT_PLANT) continue;
                this.plantSeedItem(this.key(prehistoricPlantInfo.getPlantSeedItem()));
                this.plantSeedItem(this.key(prehistoricPlantInfo.getFossilizedPlantSeedItem()));
            }
            this.basicItem((Item)ModItems.CALAMITES_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.CORDAITES_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.PALM_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.SIGILLARIA_FOSSIL_SAPLING.get());
            this.basicItem((Item)ModItems.TEMPSKYA_FOSSIL_SAPLING.get());
        }
        this.basicItem((Item)ModItems.MUSIC_DISC_ANU.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_BONES.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_DISCOVERY.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_SCARAB.get());
    }

    public ItemModelBuilder basicItem(ResourceLocation item) {
        return this.builder(new ResourceLocation(item.m_135827_(), "item/" + item.m_135815_()), item);
    }

    public void plantSeedItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/seeds/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void plantBlockItem(Block block, String suffix) {
        ResourceLocation resourceLocation = new ResourceLocation(this.key(block).m_135827_(), "block/plants/plant_" + this.key(block).m_135815_() + suffix);
        this.builder(resourceLocation, this.key(block));
    }

    public void dnaItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/dna/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void boneItem(ResourceLocation item, PrehistoricEntityInfo info, String bone) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/bone/" + info.resourceName + "/" + bone);
        this.builder(resourceLocation, item);
    }

    public void foodItem(ResourceLocation item, PrehistoricEntityInfo info, String meat) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/meat/" + info.resourceName + "_" + meat);
        this.builder(resourceLocation, item);
    }

    public void eggItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/eggs/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void spawnEggItem(Item item) {
        ((ItemModelBuilder)this.getBuilder(this.key(item).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }

    public void embyroItem(ResourceLocation item) {
        ResourceLocation resourceLocation = new ResourceLocation(item.m_135827_(), "item/embryo/" + item.m_135815_());
        this.builder(resourceLocation, item);
    }

    public void vaseItem(ResourceLocation blockLocation) {
        ResourceLocation resourceLocation = new ResourceLocation(blockLocation.m_135827_(), "item/vases/" + blockLocation.m_135815_());
        this.builder(resourceLocation, blockLocation);
    }

    public void simpleItem(ResourceLocation location, boolean block) {
        ResourceLocation resourceLocation = new ResourceLocation(location.m_135827_(), (block ? "block/" : "item/") + location.m_135815_());
        this.builder(resourceLocation, location);
    }

    public void blockItem(ResourceLocation blockLocation) {
        this.blockItem(blockLocation, "");
    }

    public void blockItem(ResourceLocation blockLocation, String suffix) {
        ResourceLocation resourceLocation = new ResourceLocation(blockLocation.m_135827_(), "item/" + blockLocation.m_135815_());
        this.existingFileHelper.trackGenerated(resourceLocation, (ExistingFileHelper.IResourceType)TEXTURE);
        ((ItemModelBuilder)this.getBuilder(blockLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockLocation.m_135827_() + ":block/" + blockLocation.m_135815_() + suffix));
    }

    private ItemModelBuilder builder(ResourceLocation resourceLocation, ResourceLocation item) {
        this.existingFileHelper.trackGenerated(resourceLocation, (ExistingFileHelper.IResourceType)TEXTURE);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", resourceLocation);
    }

    private ResourceLocation key(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }
}

