/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/world/level/levelgen/structure/pools/JigsawPlacement$Placer"})
public abstract class JigsawPlacementMixin {
    @Shadow
    @Final
    private StructureTemplateManager f_227256_;
    @Final
    @Shadow
    private RandomSource f_210320_;
    @Final
    @Shadow
    private Registry<StructureTemplatePool> f_210314_;
    @Final
    @Shadow
    private int f_210315_;
    @Final
    @Shadow
    private ChunkGenerator f_210317_;
    @Final
    @Shadow
    Deque<JigsawPlacement.PieceState> f_210321_;
    @Final
    @Shadow
    private List<? super PoolElementStructurePiece> f_210319_;

    @Inject(method={"tryPlacingChildren"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryPlacingCustomStructures(PoolElementStructurePiece structurePiece, MutableObject<VoxelShape> mutableObject, int depth, boolean bl, LevelHeightAccessor levelHeightAccessor, RandomState randomState, CallbackInfo ci) {
        boolean isBottom;
        String name = structurePiece.m_209918_().toString();
        boolean isTop = name.contains("house_taiga_top") || name.contains("house_plains_top") || name.contains("tent_option");
        boolean bl2 = isBottom = name.contains("house_taiga_base") || name.contains("house_plains_base");
        if (name.contains("fossil") && (isTop || isBottom)) {
            ci.cancel();
            StructurePoolElement structurePoolElement = structurePiece.m_209918_();
            BlockPos baseStructurePosition = structurePiece.m_72646_();
            Rotation baseStructureRotation = structurePiece.m_6830_();
            StructureTemplatePool.Projection projection = structurePoolElement.m_210539_();
            boolean baseIsRigid = projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableObject2 = new MutableObject<VoxelShape>();
            BoundingBox baseStructureBoundingBox = structurePiece.m_73547_();
            int baseMinY = baseStructureBoundingBox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo baseStructureJigSaw : structurePoolElement.m_213638_(this.f_227256_, baseStructurePosition, baseStructureRotation, this.f_210320_)) {
                StructurePoolElement targetElement;
                MutableObject<VoxelShape> mutableObject3;
                ResourceLocation baseFallbackLocation;
                Optional baseFallbackPool;
                Direction baseJigsawDirection = JigsawBlock.m_54250_((BlockState)baseStructureJigSaw.f_74676_);
                BlockPos baseJigsawPosition = baseStructureJigSaw.f_74675_;
                BlockPos expectedJigsawPosition = baseJigsawPosition.m_121945_(baseJigsawDirection);
                int k = baseJigsawPosition.m_123342_() - baseMinY;
                int l = -1;
                ResourceLocation baseTargetLocation = new ResourceLocation(baseStructureJigSaw.f_74677_.m_128461_("pool"));
                Optional baseTargetPool = this.f_210314_.m_6612_(baseTargetLocation);
                if (baseTargetPool.isEmpty() || ((StructureTemplatePool)baseTargetPool.get()).m_210590_() == 0 && !Objects.equals(baseTargetLocation, Pools.f_127186_.m_135782_()) || (baseFallbackPool = this.f_210314_.m_6612_(baseFallbackLocation = ((StructureTemplatePool)baseTargetPool.get()).m_210573_())).isEmpty() || ((StructureTemplatePool)baseFallbackPool.get()).m_210590_() == 0 && !Objects.equals(baseFallbackLocation, Pools.f_127186_.m_135782_())) continue;
                if (baseStructureBoundingBox.m_71051_((Vec3i)expectedJigsawPosition)) {
                    mutableObject3 = mutableObject2;
                    if (mutableObject2.getValue() == null) {
                        mutableObject2.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)baseStructureBoundingBox)));
                    }
                } else {
                    mutableObject3 = mutableObject;
                }
                ArrayList list = Lists.newArrayList();
                if (depth != this.f_210315_ || isBottom) {
                    list.addAll(((StructureTemplatePool)baseTargetPool.get()).m_227362_(this.f_210320_));
                }
                list.addAll(((StructureTemplatePool)baseFallbackPool.get()).m_227362_(this.f_210320_));
                Iterator targetPoolIterator = list.iterator();
                while (targetPoolIterator.hasNext() && (targetElement = (StructurePoolElement)targetPoolIterator.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation targetElementRotation : Rotation.m_221992_((RandomSource)this.f_210320_)) {
                        List allTargetJigsaws = targetElement.m_213638_(this.f_227256_, BlockPos.f_121853_, targetElementRotation, this.f_210320_);
                        BoundingBox boundingBox2 = targetElement.m_214015_(this.f_227256_, BlockPos.f_121853_, targetElementRotation);
                        int m = !bl || boundingBox2.m_71057_() > 16 ? 0 : allTargetJigsaws.stream().mapToInt(structureBlockInfo -> {
                            if (!boundingBox2.m_71051_((Vec3i)structureBlockInfo.f_74675_.m_121945_(JigsawBlock.m_54250_((BlockState)structureBlockInfo.f_74676_)))) {
                                return 0;
                            }
                            ResourceLocation resourceLocation = new ResourceLocation(structureBlockInfo.f_74677_.m_128461_("pool"));
                            Optional optional = this.f_210314_.m_6612_(resourceLocation);
                            Optional<Integer> optional2 = optional.flatMap(structureTemplatePool -> this.f_210314_.m_6612_(structureTemplatePool.m_210573_()));
                            int a = optional.map(structureTemplatePool -> structureTemplatePool.m_227357_(this.f_227256_)).orElse(0);
                            int b = optional2.map(structureTemplatePool -> structureTemplatePool.m_227357_(this.f_227256_)).orElse(0);
                            return Math.max(a, b);
                        }).max().orElse(0);
                        for (StructureTemplate.StructureBlockInfo targetJigsaw : allTargetJigsaws) {
                            int u;
                            boolean shouldSkip;
                            int s;
                            int q;
                            if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)baseStructureJigSaw, (StructureTemplate.StructureBlockInfo)targetJigsaw)) continue;
                            BlockPos targetJigsawPosition = targetJigsaw.f_74675_;
                            BlockPos vecToTargetJigsaw = expectedJigsawPosition.m_121996_((Vec3i)targetJigsawPosition);
                            BoundingBox boundingBox3 = targetElement.m_214015_(this.f_227256_, vecToTargetJigsaw, targetElementRotation);
                            int n = boundingBox3.m_162396_();
                            StructureTemplatePool.Projection targetProjection = targetElement.m_210539_();
                            boolean targetIsRigid = targetProjection == StructureTemplatePool.Projection.RIGID;
                            int targetJigsawY = targetJigsawPosition.m_123342_();
                            int p = k - targetJigsawY + JigsawBlock.m_54250_((BlockState)baseStructureJigSaw.f_74676_).m_122430_();
                            if (baseIsRigid && targetIsRigid) {
                                q = baseMinY + p;
                            } else {
                                if (l == -1) {
                                    l = this.f_210317_.m_223221_(baseJigsawPosition.m_123341_(), baseJigsawPosition.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
                                }
                                q = l - targetJigsawY;
                            }
                            int r = q - n;
                            BoundingBox boundingBox4 = boundingBox3.m_71045_(0, r, 0);
                            BlockPos blockPos6 = vecToTargetJigsaw.m_7918_(0, r, 0);
                            if (m > 0) {
                                s = Math.max(m + 1, boundingBox4.m_162400_() - boundingBox4.m_162396_());
                                boundingBox4.m_162371_(new BlockPos(boundingBox4.m_162395_(), boundingBox4.m_162396_() + s, boundingBox4.m_162398_()));
                            }
                            boolean bl3 = shouldSkip = targetElement.toString().contains("base") || targetElement.toString().contains("tent");
                            if (!shouldSkip && Shapes.m_83157_((VoxelShape)((VoxelShape)mutableObject3.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox4).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                            mutableObject3.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableObject3.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox4)), (BooleanOp)BooleanOp.f_82685_));
                            s = structurePiece.m_72647_();
                            int t = targetIsRigid ? s - p : targetElement.m_210540_();
                            PoolElementStructurePiece targetStructurePiece = new PoolElementStructurePiece(this.f_227256_, targetElement, blockPos6, t, targetElementRotation, boundingBox4);
                            if (baseIsRigid) {
                                u = baseMinY + k;
                            } else if (targetIsRigid) {
                                u = q + targetJigsawY;
                            } else {
                                if (l == -1) {
                                    l = this.f_210317_.m_223221_(baseJigsawPosition.m_123341_(), baseJigsawPosition.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
                                }
                                u = l + p / 2;
                            }
                            structurePiece.m_209916_(new JigsawJunction(expectedJigsawPosition.m_123341_(), u - k + s, expectedJigsawPosition.m_123343_(), p, targetProjection));
                            targetStructurePiece.m_209916_(new JigsawJunction(baseJigsawPosition.m_123341_(), u - targetJigsawY + t, baseJigsawPosition.m_123343_(), -p, projection));
                            this.f_210319_.add((PoolElementStructurePiece)targetStructurePiece);
                            if (!shouldSkip && depth + 1 > this.f_210315_) continue block0;
                            this.f_210321_.addLast(new JigsawPlacement.PieceState(targetStructurePiece, mutableObject3, depth + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }
}

