/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.inventory;

import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.inventory.ModMenus;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FeederMenu
extends AbstractContainerMenu {
    public static final int MEAT_SLOT_ID = 0;
    public static final int PLANT_SLOT_ID = 1;
    public static final int FISH_SLOT_ID = 2;
    private final Container container;
    private final ContainerData containerData;

    public FeederMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(3));
    }

    public FeederMenu(int id, Inventory playerInventory, Container container, ContainerData containerData) {
        super((MenuType)ModMenus.FEEDER.get(), id);
        this.container = container;
        this.containerData = containerData;
        this.m_38897_(new Slot(container, 0, 68, 61){

            public boolean m_5857_(ItemStack stack) {
                return FeederMenu.this.isMeat(stack);
            }
        });
        this.m_38897_(new Slot(container, 1, 110, 61){

            public boolean m_5857_(ItemStack stack) {
                return FeederMenu.this.isPlant(stack);
            }
        });
        this.m_38897_(new Slot(container, 2, 152, 61){

            public boolean m_5857_(ItemStack stack) {
                return FeederMenu.this.isFish(stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 8 + x * 18, 142));
        }
        this.m_38884_(containerData);
    }

    private boolean isMeat(ItemStack stack) {
        return FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), FoodType.MEAT) > 0;
    }

    private boolean isPlant(ItemStack stack) {
        return FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), FoodType.PLANT) > 0;
    }

    private boolean isFish(ItemStack stack) {
        return FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), FoodType.FISH) > 0;
    }

    public int getMeat() {
        return this.containerData.m_6413_(0);
    }

    public int getVeg() {
        return this.containerData.m_6413_(1);
    }

    public int getFish() {
        return this.containerData.m_6413_(2);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            itemStack = current.m_41777_();
            int inventorySlots = 36;
            int feederSlots = 3;
            int bottomRowEnd = 36 + feederSlots;
            int bottomRowStart = bottomRowEnd - 9;
            if (index < feederSlots ? !this.m_38903_(current, feederSlots, bottomRowEnd, true) : (this.isMeat(current) ? !this.m_38903_(current, 0, 1, false) : (this.isPlant(current) ? !this.m_38903_(current, 1, 2, false) : (this.isFish(current) ? !this.m_38903_(current, 2, 3, false) : (index < bottomRowStart ? !this.m_38903_(current, bottomRowStart, bottomRowEnd, false) : index <= bottomRowEnd && !this.m_38903_(current, feederSlots, bottomRowStart, false)))))) {
                return ItemStack.f_41583_;
            }
            if (current.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (current.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, current);
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }
}

