/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class S2CSyncActiveAnimationMessage {
    private final int entityId;
    private final String controller;
    private final String animationName;
    private final AnimationCategory category;
    private final double ticks;
    private final double speed;
    private final boolean loop;

    public S2CSyncActiveAnimationMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.controller = buf.m_130277_();
        this.animationName = buf.m_130277_();
        String name = buf.m_130277_();
        this.category = AnimationCategory.CATEGORIES.stream().filter(category1 -> category1.name().equals(name)).findFirst().orElse(AnimationCategory.NONE);
        this.ticks = buf.readDouble();
        this.speed = buf.readDouble();
        this.loop = buf.readBoolean();
    }

    public S2CSyncActiveAnimationMessage(Entity entity, String controller, AnimationLogic.ActiveAnimationInfo activeAnimationInfo) {
        this.entityId = entity.m_19879_();
        this.controller = controller;
        this.animationName = activeAnimationInfo.animationName();
        this.category = activeAnimationInfo.category();
        this.ticks = activeAnimationInfo.transitionLength();
        this.speed = activeAnimationInfo.speed();
        this.loop = activeAnimationInfo.loop();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130070_(this.controller);
        buf.m_130070_(this.animationName);
        buf.m_130070_(this.category.name());
        buf.writeDouble(this.ticks);
        buf.writeDouble(this.speed);
        buf.writeBoolean(this.loop);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.SERVER) {
            return;
        }
        contextSupplier.get().queue(() -> {
            PrehistoricAnimatable prehistoric;
            if (((NetworkManager.PacketContext)contextSupplier.get()).getPlayer() == null) {
                return;
            }
            Entity entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().f_19853_.m_6815_(this.entityId);
            if (entity instanceof PrehistoricAnimatable && (prehistoric = (PrehistoricAnimatable)entity).getAllAnimations().containsKey(this.animationName)) {
                double endTick = (double)entity.f_19853_.m_46467_() + prehistoric.getAnimation((String)this.animationName).animation.animationLength;
                AnimationLogic.ActiveAnimationInfo activeAnimationInfo = new AnimationLogic.Builder(this.animationName, endTick, this.category).forced().transitionLength(this.ticks).speed(this.speed).loop(this.loop).build();
                prehistoric.getAnimationLogic().addNextAnimation(this.controller, activeAnimationInfo);
            }
        });
    }
}

