/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class S2CMarkMessage {
    private final List<BlockPos> targets = new ArrayList<BlockPos>();
    private final List<BlockState> blocks = new ArrayList<BlockState>();
    private final boolean below;

    public S2CMarkMessage(FriendlyByteBuf buf) {
        this(buf.m_130100_(), buf.readBoolean());
    }

    public S2CMarkMessage(int[] targetArray, boolean below) {
        for (int i = 0; i < targetArray.length / 4; ++i) {
            this.targets.add(new BlockPos(targetArray[4 * i], targetArray[4 * i + 1], targetArray[4 * i + 2]));
            this.blocks.add(Block.m_49803_((int)targetArray[4 * i + 3]));
        }
        this.below = below;
    }

    public S2CMarkMessage(int[] targetArray, BlockState[] blocks, boolean below) {
        for (int i = 0; i < blocks.length; ++i) {
            this.targets.add(new BlockPos(targetArray[3 * i], targetArray[3 * i + 1], targetArray[3 * i + 2]));
            this.blocks.add(blocks[i]);
        }
        this.below = below;
    }

    public void write(FriendlyByteBuf buf) {
        int[] targetsOut = new int[this.targets.size() * 4];
        for (int i = 0; i < this.targets.size(); ++i) {
            targetsOut[4 * i] = this.targets.get(i).m_123341_();
            targetsOut[4 * i + 1] = this.targets.get(i).m_123342_();
            targetsOut[4 * i + 2] = this.targets.get(i).m_123343_();
            targetsOut[4 * i + 3] = Block.m_49956_((BlockState)this.blocks.get(i));
        }
        buf.m_130089_(targetsOut);
        buf.writeBoolean(this.below);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            if (Version.debugEnabled()) {
                DebugScreen.showPath(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), this.targets, this.blocks, this.below);
            }
        });
    }
}

