/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.recipe.AnalyzerRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.CultureVatRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.SifterRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WorktableRecipe;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ModRecipes {
    public static final Map<Item, AnalyzerRecipe> ANALYZER_RECIPES = new Object2ObjectOpenHashMap();
    private static final Map<ItemLike, Integer> WORKTABLE_FUEL_VALUES = new Object2IntOpenHashMap();
    private static final Map<ItemLike, Integer> CULTURE_VAT_FUEL_VALUES = new Object2IntOpenHashMap();
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((String)"fossil", (ResourceKey)Registry.f_122915_);
    public static final DeferredRegister<RecipeType<?>> TYPES = DeferredRegister.create((String)"fossil", (ResourceKey)Registry.f_122914_);
    public static final RegistrySupplier<RecipeSerializer<AnalyzerRecipe>> ANALYZER_SERIALIZER = SERIALIZERS.register("analyzer", () -> AnalyzerRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<RecipeSerializer<CultureVatRecipe>> CULTURE_VAT_SERIALIZER = SERIALIZERS.register("culture_vat", () -> CultureVatRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<RecipeSerializer<SifterRecipe>> SIFTER_SERIALIZER = SERIALIZERS.register("sifter", () -> SifterRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<RecipeSerializer<WorktableRecipe>> WORKTABLE_SERIALIZER = SERIALIZERS.register("worktable", () -> WorktableRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<RecipeType<AnalyzerRecipe>> ANALYZER_TYPE = TYPES.register("analyzer", () -> AnalyzerRecipe.Type.INSTANCE);
    public static final RegistrySupplier<RecipeType<CultureVatRecipe>> CULTURE_VAT_TYPE = TYPES.register("culture_vat", () -> CultureVatRecipe.Type.INSTANCE);
    public static final RegistrySupplier<RecipeType<SifterRecipe>> SIFTER_TYPE = TYPES.register("sifter", () -> SifterRecipe.Type.INSTANCE);
    public static final RegistrySupplier<RecipeType<WorktableRecipe>> WORKTABLE_TYPE = TYPES.register("worktable", () -> WorktableRecipe.Type.INSTANCE);

    public static void register() {
        SERIALIZERS.register();
        TYPES.register();
    }

    public static void initRecipes() {
        for (PrehistoricEntityInfo info : PrehistoricEntityInfo.entitiesWithBones()) {
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.armBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.footBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.legBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.legBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.ribcageBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.skullBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.tailBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.uniqueBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)info.vertebraeBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)info.dnaItem, 35.0));
        }
        ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)PrehistoricEntityInfo.MEGALODON.uniqueBoneItem).addOutput((ItemLike)Items.f_42499_, 30.0).addOutput((ItemLike)Items.f_42500_, 35.0).addOutput((ItemLike)PrehistoricEntityInfo.MEGALODON.dnaItem, 35.0));
        for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
            if (prehistoricEntityInfo.foodItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)prehistoricEntityInfo.foodItem).addOutput((ItemLike)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.eggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)prehistoricEntityInfo.eggItem).addOutput((ItemLike)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.birdEggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)prehistoricEntityInfo.birdEggItem).addOutput((ItemLike)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.cultivatedBirdEggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)prehistoricEntityInfo.cultivatedBirdEggItem).addOutput((ItemLike)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.embryoItem == null) continue;
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)prehistoricEntityInfo.embryoItem).addOutput((ItemLike)prehistoricEntityInfo.dnaItem, 100.0));
        }
        for (Enum enum_ : VanillaEntityInfo.values()) {
            if (((VanillaEntityInfo)enum_).eggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)((VanillaEntityInfo)enum_).eggItem).addOutput((ItemLike)((VanillaEntityInfo)enum_).dnaItem, 100.0));
            }
            if (((VanillaEntityInfo)enum_).embryoItem == null) continue;
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((ItemLike)((VanillaEntityInfo)enum_).embryoItem).addOutput((ItemLike)((VanillaEntityInfo)enum_).dnaItem, 100.0));
        }
        WORKTABLE_FUEL_VALUES.put((ItemLike)ModItems.POTTERY_SHARD.get(), 300);
        WORKTABLE_FUEL_VALUES.put((ItemLike)ModItems.RELIC_SCRAP.get(), 300);
        CULTURE_VAT_FUEL_VALUES.put((ItemLike)ModItems.BIO_GOO.get(), Version.debugEnabled() ? 1000 : 6000);
    }

    private static void registerAnalyzer(AnalyzerRecipe.Builder recipe) {
        ANALYZER_RECIPES.put(recipe.item.m_5456_(), recipe.build());
    }

    @Nullable
    public static SifterRecipe getSifterRecipeForItem(Container container, Level level) {
        return level.m_7465_().m_44015_((RecipeType)SIFTER_TYPE.get(), container, level).orElse(null);
    }

    @Nullable
    public static AnalyzerRecipe getAnalyzerRecipeForItem(Container container, Level level) {
        return ANALYZER_RECIPES.computeIfAbsent(container.m_8020_(0).m_41720_(), item -> level.m_7465_().m_44015_((RecipeType)ANALYZER_TYPE.get(), container, level).orElse(null));
    }

    @Nullable
    public static WorktableRecipe getWorktableRecipeForItem(WithFuelRecipe.ContainerWithAnyFuel container, Level level) {
        return level.m_7465_().m_44015_((RecipeType)WORKTABLE_TYPE.get(), (Container)container, level).orElse(null);
    }

    @Nullable
    public static CultureVatRecipe getCultureVatRecipeForItem(WithFuelRecipe.ContainerWithAnyFuel container, Level level) {
        return level.m_7465_().m_44015_((RecipeType)CULTURE_VAT_TYPE.get(), (Container)container, level).orElse(null);
    }

    public static boolean isWorktableFuel(ItemLike itemLike) {
        return WORKTABLE_FUEL_VALUES.containsKey(itemLike);
    }

    public static int getWorktableFuelValue(ItemLike itemLike) {
        return WORKTABLE_FUEL_VALUES.getOrDefault(itemLike, 0);
    }

    public static boolean isCultureVatFuel(ItemLike itemLike) {
        return CULTURE_VAT_FUEL_VALUES.containsKey(itemLike);
    }

    public static int getCultureVatFuelValue(ItemLike itemLike) {
        return CULTURE_VAT_FUEL_VALUES.getOrDefault(itemLike, 0);
    }
}

