/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiOutputAndSlotsRecipeBuilder<T extends MultiOutputAndSlotsRecipeBuilder<T>>
implements RecipeBuilder {
    protected final String modId;
    protected final ItemLike itemInput;
    protected final TagKey<Item> tagInput;
    protected final NavigableMap<ItemHolder, Double> weightedOutputs = new TreeMap<ItemHolder, Double>();
    public double total;

    protected MultiOutputAndSlotsRecipeBuilder(String modId, ItemLike itemInput) {
        this.modId = modId;
        this.itemInput = itemInput;
        this.tagInput = null;
    }

    protected MultiOutputAndSlotsRecipeBuilder(String modId, TagKey<Item> tagInput) {
        this.modId = modId;
        this.itemInput = null;
        this.tagInput = tagInput;
    }

    public MultiOutputAndSlotsRecipeBuilder<T> addOutput(ItemLike itemLike, double weight) {
        return this.addOutput(itemLike, 1, weight);
    }

    public MultiOutputAndSlotsRecipeBuilder<T> addOutput(ItemLike itemLike, int count, double weight) {
        this.total += weight;
        this.weightedOutputs.put(new ItemHolder(Registry.f_122827_.m_7981_((Object)itemLike.m_5456_()), count), weight);
        return this;
    }

    @NotNull
    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    @NotNull
    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return Items.f_42584_;
    }

    public void m_176498_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, this.getDefaultRecipeId());
    }

    public void m_176500_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull String recipeId) {
        ResourceLocation resourceLocation2 = new ResourceLocation(recipeId);
        ResourceLocation resourceLocation = this.getDefaultRecipeId();
        if (resourceLocation2.equals((Object)resourceLocation)) {
            throw new IllegalStateException("Recipe " + recipeId + " should remove its 'save' argument as it is equal to default one");
        }
        this.m_126140_(consumer, resourceLocation2);
    }

    protected abstract ResourceLocation getDefaultRecipeId();

    public record ItemHolder(ResourceLocation location, int count) implements Comparable<ItemHolder>
    {
        @Override
        public int compareTo(@NotNull ItemHolder o) {
            return this.location.m_135815_().compareTo(o.location.m_135815_());
        }
    }

    public static abstract class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeLocation;
        private final Ingredient ingredient;
        private final NavigableMap<ItemHolder, Double> weightedOutputs;

        protected Result(ResourceLocation recipeLocation, Ingredient ingredient, NavigableMap<ItemHolder, Double> weightedOutputs) {
            this.recipeLocation = recipeLocation;
            this.ingredient = ingredient;
            this.weightedOutputs = weightedOutputs;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.ingredient.m_43942_());
            JsonArray outputs = new JsonArray();
            for (Map.Entry output : this.weightedOutputs.entrySet()) {
                ItemHolder itemStack = (ItemHolder)output.getKey();
                JsonObject outputObject = new JsonObject();
                outputObject.addProperty("item", itemStack.location.toString());
                if (itemStack.count > 1) {
                    outputObject.addProperty("count", (Number)itemStack.count);
                }
                outputObject.addProperty("weight", (Number)output.getValue());
                outputs.add((JsonElement)outputObject);
            }
            json.add("outputs", (JsonElement)outputs);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.recipeLocation;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

