/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.chunk;

import com.github.teamfossilsarcheology.fossil.world.biome.ModBiomes;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;

public class TreasureChunkGenerator
extends ChunkGenerator {
    public static final Codec<TreasureChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> TreasureChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(source -> source.biomes)).apply((Applicative)instance, instance.stable(TreasureChunkGenerator::new)));
    private final Registry<Biome> biomes;

    public TreasureChunkGenerator(Registry<StructureSet> registry, Registry<Biome> registry2) {
        super(registry, Optional.empty(), (BiomeSource)new FixedBiomeSource(registry2.m_214121_(ModBiomes.TREASURE_ROOM_KEY)));
        this.biomes = registry2;
    }

    private void generatePositions() {
        StructureSet structureSet = (StructureSet)this.f_207955_.m_7745_(ModStructures.TREASURE_ROOM_KEY.m_135782_());
        if (structureSet != null) {
            for (StructureSet.StructureSelectionEntry structure : structureSet.f_210003_()) {
                this.f_223022_.computeIfAbsent((Structure)structure.f_210026_().m_203334_(), configuredStructureFeature -> new ArrayList()).add(structureSet.f_210004_());
            }
            StructurePlacement structurePlacement = structureSet.f_210004_();
            if (structurePlacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement placement = (ConcentricRingsStructurePlacement)structurePlacement;
                this.f_204350_.put(placement, CompletableFuture.completedFuture(List.of(new ChunkPos(0, 0))));
            }
        }
    }

    public void m_223100_(RandomState random) {
        if (!this.f_207958_) {
            this.generatePositions();
            this.f_207958_ = true;
        }
    }

    public void m_213600_(List<String> info, RandomState random, BlockPos pos) {
    }

    @NotNull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void m_214194_(WorldGenRegion level, StructureManager structureFeatureManager, RandomState random, ChunkAccess chunk) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.m_6978_((BlockPos)mutable.m_122178_(x, this.m_142062_(), z), Blocks.f_50752_.m_49966_(), false);
            }
        }
    }

    public void m_6929_(WorldGenRegion level) {
    }

    public int m_6331_() {
        return 256;
    }

    @NotNull
    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return -63;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return 0;
    }

    @NotNull
    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState random) {
        return new NoiseColumn(level.m_141937_(), new BlockState[0]);
    }
}

