/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.village;

import com.github.teamfossilsarcheology.fossil.world.feature.village.forge.ModVillagesImpl;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ModVillages {
    public static final Tuple ARCHEOLOGIST_HOUSE_DESERT = ModVillages.createStructure("houses/archeo_house_desert", 1);
    public static final Tuple PALEONTOLOGIST_HOUSE_DESERT = ModVillages.createStructure("houses/paleo_house_desert", 1);
    public static final Tuple ARCHEOLOGIST_HOUSE_PLAINS = ModVillages.createStructure("houses/archeo_house_plains_top", 1);
    public static final Tuple PALEONTOLOGIST_HOUSE_PLAINS = ModVillages.createStructure("houses/paleo_house_plains_top", 1);
    public static final Tuple ARCHEOLOGIST_HOUSE_SAVANNA = ModVillages.createStructure("houses/archeo_house_savanna", 1);
    public static final Tuple PALEONTOLOGIST_HOUSE_SAVANNA = ModVillages.createStructure("houses/paleo_house_savanna", 1);
    public static final Tuple ARCHEOLOGIST_HOUSE_SNOWY = ModVillages.createStructure("houses/archeo_house_snowy", 1);
    public static final Tuple PALEONTOLOGIST_HOUSE_SNOWY = ModVillages.createStructure("houses/paleo_house_snowy", 1);
    public static final Tuple ARCHEOLOGIST_HOUSE_TAIGA = ModVillages.createStructure("houses/archeo_house_taiga_top", 1);
    public static final Tuple PALEONTOLOGIST_HOUSE_TAIGA = ModVillages.createStructure("houses/paleo_house_taiga", 1);
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    private static Tuple createStructure(String name, int weight) {
        return new Tuple("fossil:" + name, weight);
    }

    public static void addBuildingToPool(StructureTemplatePool pool, Registry<StructureProcessorList> registry, Tuple building) {
        if (pool == null) {
            return;
        }
        Holder emptyProcessorList = registry.m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)building.location, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < building.weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)building.weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void register() {
        ModVillagesImpl.register();
    }

    public record Tuple(String location, int weight) {
        public ResourceLocation resourceLocation() {
            return new ResourceLocation(this.location);
        }
    }
}

