/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.AbstractAnimationList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.EntityList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.InstructionsList;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.InstructionMessage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5676;
import net.minecraft.class_7919;

public class InstructionTab
extends DebugTab<Prehistoric> {
    public static final Map<UUID, Pair> INSTRUCTIONS = new Object2ObjectOpenHashMap();
    private InstructionsList instructions;
    private AbstractAnimationList animations;
    private EntityList attackEntities;
    private EntityList leapEntities;
    public static class_1297 entityListHighlight;
    public static class_1297 highlightInstructionEntity;
    public static Instruction highlightInstruction;
    public static Instruction.Type positionMode;
    public static int teleportRotation;
    public static Prehistoric activeEntity;

    protected InstructionTab(DebugScreen debugScreen, Prehistoric entity) {
        super(debugScreen, entity);
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        this.instructions = this.addWidget(new InstructionsList(INSTRUCTIONS.computeIfAbsent(((Prehistoric)this.entity).method_5667(), id -> new Pair(((Prehistoric)this.entity).method_5628(), new ArrayList<Instruction>())), this.minecraft));
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Start"), button -> {
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).method_5628(), true, InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions));
            this.debugScreen.method_25419();
            this.onClose();
        }).method_46434(5, 340, 50, 20).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Stop"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).method_5628(), true, List.of()))).method_46434(5, 365, 50, 20).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Stop All"), button -> {
            for (Map.Entry<UUID, Pair> entry : INSTRUCTIONS.entrySet()) {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(entry.getValue().id, true, List.of()));
            }
            this.debugScreen.method_25419();
            this.onClose();
        }).method_46434(60, 365, 70, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stops Instruction for all mobs"))).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Start All"), button -> {
            for (Map.Entry<UUID, Pair> entry : INSTRUCTIONS.entrySet()) {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(entry.getValue().id, true, entry.getValue().instructions));
            }
            this.debugScreen.method_25419();
            this.onClose();
        }).method_46434(60, 340, 70, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Starts Instruction for all mobs"))).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Debug"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new InstructionMessage(((Prehistoric)this.entity).method_5628(), true, InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions))).method_46434(135, 340, 50, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Starts Instruction without closing the debug menu"))).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Walk Builder"), button -> {
            positionMode = Instruction.Type.MOVE_TO;
            this.debugScreen.method_25419();
        }).method_46434(220, 5, 100, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Left click to place, Right click to cancel"))).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Teleport Builder"), button -> {
            positionMode = Instruction.Type.TELEPORT_TO;
            teleportRotation = 0;
            this.debugScreen.method_25419();
        }).method_46434(220, 30, 100, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Left click to place, Right click to cancel, Mousewheel to rotate"))).method_46431());
        if (this.entity instanceof Meganeura) {
            this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Attach Builder"), button -> {
                positionMode = Instruction.Type.ATTACH_TO;
                this.debugScreen.method_25419();
            }).method_46434(220, 55, 100, 20).method_46431());
        }
        List list = ((Prehistoric)this.entity).field_6002.method_18466(class_1309.class, class_4051.method_36626().method_18418(30.0).method_36627(), (class_1309)this.entity, ((Prehistoric)this.entity).method_5829().method_1014(30.0));
        this.leapEntities = new EntityList(width - 315, 200, 300, list, this.minecraft, entity1 -> {
            Instruction.LeapAttack instruction = new Instruction.LeapAttack(entity1.method_5628());
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        });
        if (this.entity instanceof PrehistoricFlying) {
            this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Fly Builder"), button -> {
                positionMode = Instruction.Type.FLY_TO;
                this.debugScreen.method_25419();
            }).method_46434(220, 55, 100, 20).method_46431());
            this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Land Builder"), button -> {
                positionMode = Instruction.Type.FLY_LAND;
                this.debugScreen.method_25419();
            }).method_46434(220, 80, 100, 20).method_46431());
        }
        if (this.entity instanceof PrehistoricLeaping) {
            this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Leap Builder"), button -> {
                positionMode = Instruction.Type.LEAP_LAND;
                this.debugScreen.method_25419();
            }).method_46434(220, 55, 100, 20).method_46431());
            this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Leap"), button -> {
                this.closeLists();
                this.addWidget(this.leapEntities);
            }).method_46434(width - 115, 5, 90, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Won't save correctly when leaving the world"))).method_46431());
        }
        this.attackEntities = new EntityList(width - 315, 200, 300, list, this.minecraft, entity1 -> {});
        List<String> controllers = ((Prehistoric)this.entity).getAnimatableInstanceCache().getManagerForId((long)((Prehistoric)this.entity).method_5628()).getAnimationControllers().keySet().stream().toList();
        this.animations = new AnimationList(width - 315, ((Prehistoric)this.entity).getAllAnimations(), controllers, this.minecraft, animationObject -> {
            Instruction.PlayAnim instruction = new Instruction.PlayAnim(animationObject.name(), animationObject.controller(), animationObject.loop(), animationObject.transitionLength());
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        });
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Animations"), button -> {
            this.closeLists();
            this.addWidget(this.animations);
        }).method_46434(width - 215, 5, 90, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stops and plays animation x times or for x seconds"))).method_46431());
        class_342 zPosInput = this.addWidget(new class_342(this.minecraft.field_1772, 325, 30, 30, 20, (class_2561)class_2561.method_43470((String)"")));
        zPosInput.method_1852(new DecimalFormat("##", DecimalFormatSymbols.getInstance(Locale.US)).format(5L));
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Idle"), button -> {
            Instruction.Idle instruction = new Instruction.Idle(Integer.parseInt(zPosInput.method_1882()) * 20);
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        }).method_46434(325, 5, 70, 20).method_46431());
        this.addWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Sleep"), button -> {
            Instruction.Sleep instruction = new Instruction.Sleep(Integer.parseInt(zPosInput.method_1882()) * 20);
            this.instructions.addInstruction(instruction);
            InstructionTab.INSTRUCTIONS.get((Object)((Prehistoric)this.entity).method_5667()).instructions.add(instruction);
        }).method_46434(400, 5, 70, 20).method_46431());
    }

    private void closeLists() {
        this.listeners.remove((Object)this.leapEntities);
        this.renderables.remove((Object)this.leapEntities);
        this.listeners.remove((Object)this.animations);
        this.renderables.remove((Object)this.animations);
    }

    @Override
    protected void onOpen() {
        activeEntity = (Prehistoric)this.entity;
    }

    @Override
    protected void onClose() {
        activeEntity = null;
    }

    public static void addPosition(class_3965 hitResult) {
        if (activeEntity == null) {
            return;
        }
        class_2338 target = hitResult.method_17777().method_10093(hitResult.method_17780());
        if (positionMode == Instruction.Type.MOVE_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.MoveTo(target));
        } else if (positionMode == Instruction.Type.FLY_LAND) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.FlyLand(target));
        } else if (positionMode == Instruction.Type.TELEPORT_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.TeleportTo(target, -teleportRotation + 180));
        } else if (positionMode == Instruction.Type.ATTACH_TO) {
            target = hitResult.method_17777();
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.AttachTo(target, hitResult.method_17780(), hitResult.method_17784()));
        } else if (positionMode == Instruction.Type.LEAP_LAND) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.LeapLand(hitResult.method_17784(), hitResult.method_17784().method_1031(0.0, 2.0, 0.0)));
        }
    }

    public static void addFlyPosition(class_2338 target) {
        if (positionMode == Instruction.Type.FLY_TO) {
            InstructionTab.INSTRUCTIONS.get((Object)InstructionTab.activeEntity.method_5667()).instructions.add(new Instruction.FlyTo(target));
        }
    }

    public static boolean positionActive() {
        return positionMode != Instruction.Type.IDLE;
    }

    @Override
    protected void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
    }

    static {
        positionMode = Instruction.Type.IDLE;
    }

    public record Pair(int id, List<Instruction> instructions) {
    }

    private static class AnimationList
    extends AbstractAnimationList {
        public AnimationList(int x0, Map<String, ? extends AnimationInfo> animations, List<String> controllers, class_310 minecraft, Consumer<AbstractAnimationList.AnimationObject> function) {
            super(x0, 300, 25, 60, animations, minecraft, function);
            int buttonX = x0 + this.rowWidth + 15;
            if (!controllers.isEmpty()) {
                this.currentControllerName = controllers.get(0);
                this.addWidget(class_5676.method_32606(class_2561::method_43470).method_32620(controllers).method_32619((Object)this.currentControllerName).method_32617(buttonX, this.field_19085, 100, 20, (class_2561)class_2561.method_43470((String)""), (cycleButton, controller) -> {
                    this.currentControllerName = controller;
                }));
            }
            this.addWidget(new DebugSlider(buttonX, this.field_19085 + 25, 100, 20, (class_2561)class_2561.method_43470((String)"Count: "), (class_2561)class_2561.method_43470((String)""), 0.0, 20.0, this.transitionLength, 1.0, 3, true){

                @Override
                protected void method_25344() {
                    transitionLength = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(class_5676.method_32613((boolean)this.loop).method_32617(buttonX, this.field_19085 + 50, 100, 20, (class_2561)class_2561.method_43470((String)"Time based"), (button, loop) -> {
                this.loop = loop;
            }));
        }
    }
}

