/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4459;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class PlayerPath {
    private class_9[] openSet = new class_9[0];
    private class_9[] closedSet = new class_9[0];
    public final List<class_9> nodes;
    @Nullable
    public Set<class_4459> targetNodes;
    private int nextNodeIndex;
    public int sweepNextNodeIndex;
    private final class_2338 target;
    private final float distToTarget;
    private final boolean reached;
    public final List<class_2338> blockPoses;

    public PlayerPath(List<class_9> list, class_2338 blockPos, boolean bl) {
        this.nodes = list;
        this.blockPoses = list.stream().map(node -> new class_2338(node.field_40, node.field_39, node.field_38)).collect(Collectors.toList());
        this.target = blockPos;
        this.distToTarget = list.isEmpty() ? Float.MAX_VALUE : this.nodes.get(this.nodes.size() - 1).method_21654(this.target);
        this.reached = bl;
    }

    public boolean removeForcedNode(class_2338 pos) {
        int idx = this.blockPoses.indexOf(pos);
        if (idx != -1) {
            this.nodes.remove(idx);
            this.blockPoses.remove(idx);
            return true;
        }
        return false;
    }

    public boolean addForcedNode(class_2338 pos) {
        if (!this.blockPoses.contains(pos)) {
            this.nodes.add(new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260()));
            this.blockPoses.add(pos);
            return true;
        }
        return false;
    }

    public void advance() {
        ++this.nextNodeIndex;
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public class_9 getEndNode() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public class_9 getNode(int index) {
        return this.nodes.get(index);
    }

    public void truncateNodes(int length) {
        if (this.nodes.size() > length) {
            this.nodes.subList(length, this.nodes.size()).clear();
        }
    }

    public void replaceNode(int index, class_9 point) {
        this.nodes.set(index, point);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public int getDebugNodeIndex() {
        return Math.min(this.getNodeCount() - 1, PathingRenderer.pathIndex);
    }

    public void setSweepNodeIndex(int currentPathIndex) {
        this.sweepNextNodeIndex = Math.min(this.getNodeCount() - 1, currentPathIndex);
    }

    public class_243 getEntityPosAtNode(int index) {
        class_9 node = this.nodes.get(index);
        double d = (double)node.field_40 + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5;
        double e = node.field_39;
        double f = (double)node.field_38 + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5;
        return new class_243(d, e, f);
    }

    public class_2338 getNodePos(int i) {
        return this.nodes.get(i).method_22879();
    }

    public class_243 getSweepEntityPos(class_1297 entity) {
        return this.getEntityPosAtNode(this.sweepNextNodeIndex);
    }

    public class_243 getNextEntityPos(class_1297 entity) {
        return this.getEntityPosAtNode(Math.min(this.getNodeCount() - 1, PathingRenderer.pathIndex));
    }

    public class_2338 getNextNodePos() {
        return this.nodes.get(this.nextNodeIndex).method_22879();
    }

    public class_9 getNextNode() {
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public class_9 getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable PlayerPath pathentity) {
        if (pathentity == null) {
            return false;
        }
        if (pathentity.nodes.size() != this.nodes.size()) {
            return false;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            class_9 node = this.nodes.get(i);
            class_9 node2 = pathentity.nodes.get(i);
            if (node.field_40 == node2.field_40 && node.field_39 == node2.field_39 && node.field_38 == node2.field_38) continue;
            return false;
        }
        return true;
    }

    void setDebug(class_9[] openSet, class_9[] closedSet, Set<class_4459> targetNodes) {
        this.openSet = openSet;
        this.closedSet = closedSet;
        this.targetNodes = targetNodes;
    }

    public class_9[] getOpenSet() {
        return this.openSet;
    }

    public class_9[] getClosedSet() {
        return this.closedSet;
    }

    public boolean canReach() {
        return this.reached;
    }

    public String toString() {
        return "Path(length=" + this.nodes.size() + ")";
    }

    public class_2338 getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }
}

