/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.PathingScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugLargePath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class WaterPathFinder
extends PlayerPathFinder {
    public static List<class_2338> sweeped;
    static final float EPSILON = 1.0E-8f;

    public WaterPathFinder(PlayerNodeEvaluator nE, int i) {
        super(nE, i);
    }

    @Override
    @Nullable
    public PlayerPath findPath(class_1950 region, class_1657 player, Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.openSet.method_5();
        this.closedSet.clear();
        this.nodeEvaluator.prepare(region, player);
        class_9 node = this.nodeEvaluator.getStart();
        Map<class_4459, class_2338> map = targetPositions.stream().collect(Collectors.toMap(blockPos -> this.nodeEvaluator.getGoal(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), Function.identity()));
        long start = System.nanoTime();
        if (targetPositions.size() == 1 && PathingDebug.pos3 != null) {
            class_243 max;
            class_243 base;
            double f;
            double e;
            Map.Entry target = (Map.Entry)map.entrySet().stream().toList().get(0);
            double d = (double)((class_4459)target.getKey()).field_40 + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5;
            class_243 vec = new class_243(d, e = (double)((class_4459)target.getKey()).field_39, f = (double)((class_4459)target.getKey()).field_38 + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5).method_1020(PathingDebug.pos3);
            if (this.sweep(vec, base = PathingDebug.pos3.method_1031((double)(-PathingRenderer.getBbWidth() * 0.5f), 0.0, (double)(-PathingRenderer.getBbWidth() * 0.5f)), max = base.method_1031((double)PathingRenderer.getBbWidth(), (double)PathingRenderer.getBbHeight(), (double)PathingRenderer.getBbWidth()))) {
                DebugLargePath path = new DebugLargePath(List.of(node, (class_9)target.getKey()), (class_2338)target.getValue(), false);
                path.setDebug(this.openSet.method_35493(), (class_9[])this.closedSet.toArray(class_9[]::new), map.keySet());
                return path;
            }
        }
        System.out.println("Sweep time: " + (System.nanoTime() - start));
        start = System.nanoTime();
        PlayerPath path = this.findPath(node, map, maxRange, accuracy, searchDepthMultiplier);
        System.out.println("Path time: " + (System.nanoTime() - start));
        this.nodeEvaluator.done();
        if (path != null) {
            path = DebugLargePath.createFromPath(path);
            path.setDebug(this.openSet.method_35493(), (class_9[])this.closedSet.toArray(class_9[]::new), map.keySet());
        }
        return path;
    }

    class_2350 getDirection(class_9 pos, Set<class_4459> targets) {
        for (class_4459 target : targets) {
            int xDiff = target.field_40 - pos.field_40;
            if (xDiff != 0) {
                return xDiff > 0 ? class_2350.field_11034 : class_2350.field_11039;
            }
            int zDiff = target.field_38 - pos.field_38;
            if (zDiff != 0) {
                return zDiff > 0 ? class_2350.field_11035 : class_2350.field_11043;
            }
            int yDiff = target.field_39 - pos.field_39;
            if (yDiff == 0) continue;
            return yDiff > 0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        return class_2350.field_11033;
    }

    @Override
    @Nullable
    protected PlayerPath findPath(class_9 node, Map<class_4459, class_2338> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        Set<class_4459> set = targetPos.keySet();
        node.field_36 = 0.0f;
        node.field_47 = node.field_34 = this.getBestH(node, set);
        this.openSet.method_5();
        this.openSet.method_2(node);
        class_4459 targetN = (class_4459)set.stream().findFirst().get();
        System.out.println("Distance " + node.method_31((class_9)targetN) + " dist: " + this.dist(node, (class_9)targetN));
        int i = 1;
        HashSet set3 = Sets.newHashSetWithExpectedSize((int)set.size());
        int j = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        while (!this.openSet.method_8() && i < j) {
            System.out.println(i);
            class_9 node2 = this.openSet.method_6();
            this.closedSet.add(node2);
            System.out.println(node2 + " f: " + node2.field_47 + " g: " + node2.field_36 + " h: " + node2.field_34 + " walkDistance: " + node2.field_46);
            node2.field_42 = true;
            for (class_4459 target2 : set) {
                if (node2.method_21653((class_9)target2) > (float)accuracy) continue;
                target2.method_21665();
                set3.add(target2);
            }
            if (!set3.isEmpty()) break;
            if (node2.method_31(node) >= maxRange) continue;
            int k = this.nodeEvaluator.getNeighbors(this.neighbors, node2);
            for (int l = 0; l < k; ++l) {
                class_9 node3 = this.neighbors[l];
                float f = node2.method_31(node3);
                node3.field_46 = node2.field_46 + f;
                float g = node2.field_36 + f + node3.field_43;
                if (node3.field_46 >= maxRange || node3.method_27() && g >= node3.field_36) continue;
                node3.field_35 = node2;
                node3.field_36 = g;
                node3.field_34 = this.getBestH(node3, set);
                if (node3.method_27()) {
                    this.openSet.method_3(node3, node3.field_36 + node3.field_34);
                    continue;
                }
                node3.field_47 = node3.field_36 + node3.field_34;
                System.out.println("Adding " + node3 + " f: " + node3.field_47 + " g: " + node3.field_36 + " h: " + node3.field_34 + " walkDistance: " + node3.field_46);
                this.openSet.method_2(node3);
            }
            ++i;
        }
        Optional<PlayerPath> optional = !set3.isEmpty() ? set3.stream().map(target -> this.reconstructPath(target.method_21664(), (class_2338)targetPos.get(target), true)).min(Comparator.comparingInt(PlayerPath::getNodeCount)) : set.stream().map(target -> this.reconstructPath(target.method_21664(), (class_2338)targetPos.get(target), false)).min(Comparator.comparingDouble(PlayerPath::getDistToTarget).thenComparingInt(PlayerPath::getNodeCount));
        return optional.orElse(null);
    }

    @Override
    public float getBestH(class_9 node, Set<class_4459> targets) {
        float f = Float.MAX_VALUE;
        for (class_4459 target : targets) {
            float g = this.dist(node, (class_9)target);
            target.method_21662(g, node);
            f = Math.min(g, f);
        }
        return f;
    }

    public float dist(class_9 f, class_9 l) {
        float xDiff = Math.abs(l.field_40 - f.field_40);
        float yDiff = Math.abs(l.field_39 - f.field_39);
        float zDiff = Math.abs(l.field_38 - f.field_38);
        float min = Math.min(Math.min(xDiff, yDiff), zDiff);
        float max = Math.max(Math.max(xDiff, yDiff), zDiff);
        float tripleAxis = min;
        float doubleAxis = xDiff + yDiff + zDiff - max - 2.0f * min;
        float singleAxis = max - doubleAxis - tripleAxis;
        return (float)PathingScreen.face * singleAxis + (float)PathingScreen.edge * doubleAxis + (float)PathingScreen.corner * tripleAxis;
    }

    private boolean sweep(class_243 vec, class_243 base, class_243 max) {
        sweeped = new ArrayList<class_2338>();
        float t = 0.0f;
        float max_t = (float)vec.method_1033();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] trails = new float[3];
        int[] leadEdge = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            float value = (float)axis.method_10172(vec.field_1352, vec.field_1351, vec.field_1350);
            int dir = value >= 0.0f ? 1 : 0;
            int i = axis.ordinal();
            step[i] = dir != 0 ? 1 : -1;
            float lead = (float)(dir != 0 ? axis.method_10172(max.field_1352, max.field_1351, max.field_1350) : axis.method_10172(base.field_1352, base.field_1351, base.field_1350));
            trails[i] = (float)(dir != 0 ? axis.method_10172(base.field_1352, base.field_1351, base.field_1350) : axis.method_10172(max.field_1352, max.field_1351, max.field_1350));
            leadEdge[i] = WaterPathFinder.leadEdgeToInt(lead, step[i]);
            tri[i] = WaterPathFinder.trailEdgeToInt(trails[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = class_3532.method_15379((float)(max_t / value));
            float dist = dir != 0 ? (float)(leadEdge[i] + 1) - lead : lead - (float)leadEdge[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        for (int i = 0; i < 3; ++i) {
            float value = WaterPathFinder.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = WaterPathFinder.element(dir ? max : base, i);
            trails[i] = WaterPathFinder.element(dir ? base : max, i);
            leadEdge[i] = WaterPathFinder.leadEdgeToInt(lead, step[i]);
            tri[i] = WaterPathFinder.trailEdgeToInt(trails[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = class_3532.method_15379((float)(max_t / value));
            float dist = dir ? (float)(leadEdge[i] + 1) - lead : lead - (float)leadEdge[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        class_2338.class_2339 pos = new class_2338.class_2339();
        do {
            class_2350.class_2351 axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051) : (tNext[1] < tNext[2] ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
            int idx = axis.ordinal();
            float dt = tNext[idx] - t;
            t = tNext[idx];
            int n = idx;
            leadEdge[n] = leadEdge[n] + step[idx];
            int n2 = idx;
            tNext[n2] = tNext[n2] + tDelta[idx];
            for (class_2350.class_2351 axis2 : class_2350.class_2351.values()) {
                int i;
                int n3 = i = axis2.ordinal();
                trails[n3] = trails[n3] + dt * normed[i];
                tri[i] = WaterPathFinder.trailEdgeToInt(trails[i], step[i]);
            }
            int stepx = step[0];
            int x0 = idx == 0 ? leadEdge[0] : tri[0];
            int x1 = leadEdge[0] + stepx;
            int stepy = step[1];
            int y0 = idx == 1 ? leadEdge[1] : tri[1];
            int y1 = leadEdge[1] + stepy;
            int stepz = step[2];
            int z0 = idx == 2 ? leadEdge[2] : tri[2];
            int z1 = leadEdge[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        class_2680 block = this.nodeEvaluator.level.method_8320((class_2338)pos.method_10103(x, y, z));
                        sweeped.add(pos.method_10062());
                        if (block.method_26171((class_1922)this.nodeEvaluator.level, (class_2338)pos, class_10.field_48)) continue;
                        System.out.format("%s, %s", block.method_26204(), pos);
                        System.out.println();
                        return false;
                    }
                    class_7 below = this.nodeEvaluator.getBlockPathType((class_1922)this.nodeEvaluator.level, x, y0 - 1, z);
                    if (below == class_7.field_14 || below == class_7.field_7) {
                        System.out.format("below: %s", below);
                        System.out.println();
                        return false;
                    }
                    class_7 in = this.nodeEvaluator.getBlockPathType((class_1922)this.nodeEvaluator.level, x, y0, z);
                    float malus = PathingDebug.getPathfindingMalus(in);
                    if (malus < 0.0f || malus > 8.0f) {
                        System.out.format("in: %s, %s", in, Float.valueOf(malus));
                        System.out.println();
                        return false;
                    }
                    if (in != class_7.field_3 && in != class_7.field_9 && in != class_7.field_17) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(class_243 v, int i) {
        return switch (i) {
            case 0 -> (float)v.field_1352;
            case 1 -> (float)v.field_1351;
            case 2 -> (float)v.field_1350;
            default -> 0.0f;
        };
    }
}

