/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.jei;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.recipe.MultiOutputAndSlotsRecipe;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public abstract class MultiOutputCategory<T extends MultiOutputAndSlotsRecipe>
implements IRecipeCategory<T> {
    private static final class_2960 TEXTURE = FossilMod.location("textures/gui/multi_output.png");
    private static final DecimalFormat FORMAT = new DecimalFormat("#.#'%'");
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<T, List<SlotItem>> probabilities = CacheBuilder.newBuilder().build(new CacheLoader<T, List<SlotItem>>(){
        private static final int COLUMNS = 5;
        private static final int ROWS = 3;

        @NotNull
        public List<SlotItem> load(@NotNull T recipe) {
            Iterator iterator = ((MultiOutputAndSlotsRecipe)recipe).getWeightedOutputs().entrySet().iterator();
            ArrayList<WeightedItem> sortedOutputs = new ArrayList<WeightedItem>();
            if (iterator.hasNext()) {
                double total = (Double)((MultiOutputAndSlotsRecipe)recipe).getWeightedOutputs().lastKey();
                Map.Entry entry = iterator.next();
                double previous = (Double)entry.getKey();
                sortedOutputs.add(new WeightedItem(previous / total * 100.0, (class_1799)entry.getValue()));
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sortedOutputs.add(new WeightedItem(((Double)entry.getKey() - previous) / total * 100.0, (class_1799)entry.getValue()));
                    previous = (Double)entry.getKey();
                }
            }
            sortedOutputs.sort((o1, o2) -> DoubleComparators.OPPOSITE_COMPARATOR.compare(o1.probability, o2.probability));
            int numPerPage = 15;
            Map<Integer, List<WeightedItem>> groupedOutputs = sortedOutputs.stream().collect(Collectors.groupingBy(weightedItem -> sortedOutputs.indexOf(weightedItem) % numPerPage));
            ArrayList<SlotItem> newOutputs = new ArrayList<SlotItem>();
            for (int i = 0; i < groupedOutputs.size(); ++i) {
                int x = i % 5;
                int y = i / 5;
                newOutputs.add(new SlotItem(groupedOutputs.get(i), 8 + x * 30, 21 + y * 25));
            }
            return newOutputs;
        }
    });

    protected MultiOutputCategory(IGuiHelper guiHelper, class_1935 iconItem) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 152, 106);
        this.icon = guiHelper.createDrawableItemStack(new class_1799(iconItem));
    }

    public void draw(@NotNull T recipe, IRecipeSlotsView recipeSlotsView, @NotNull class_4587 poseStack, double mouseX, double mouseY) {
        Optional currentStack;
        List slotItems = (List)this.probabilities.getUnchecked(recipe);
        List slots = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT);
        block0: for (int i = 0; i < slots.size() && !(currentStack = ((IRecipeSlotView)slots.get(i)).getDisplayedItemStack()).isEmpty(); ++i) {
            for (WeightedItem item : ((SlotItem)slotItems.get((int)i)).items) {
                if (!class_1799.method_7984((class_1799)((class_1799)currentStack.get()), (class_1799)item.stack)) continue;
                this.renderProbability(poseStack, class_310.method_1551().field_1772, item.probability, ((SlotItem)slotItems.get((int)i)).x, ((SlotItem)slotItems.get((int)i)).y);
                continue block0;
            }
        }
    }

    private void renderProbability(class_4587 poseStack, class_327 fr, double percentage, int xPosition, int yPosition) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 300.0);
        String string = FORMAT.format(percentage);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        float xOffset = Math.min(11.0f, (float)fr.method_1727(string) / 2.0f);
        fr.method_27521(string, (float)(xPosition + 8) - xOffset, (float)(yPosition + 16 + 1), 0xFFFFFF, true, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        bufferSource.method_22993();
        poseStack.method_22909();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int centerX = 75;
        builder.addSlot(RecipeIngredientRole.INPUT, centerX - 7, 2).addIngredients(((MultiOutputAndSlotsRecipe)recipe).getInput());
        List outputs = (List)this.probabilities.getUnchecked(recipe);
        for (SlotItem output : outputs) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, output.x, output.y + 1).addIngredients(class_1856.method_26964(output.items.stream().map(weightedItem -> weightedItem.stack)));
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public record SlotItem(List<WeightedItem> items, int x, int y) {
    }

    public record WeightedItem(double probability, class_1799 stack) {
    }
}

